/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.destinations;

import com.sap.core.connectivity.api.Destination;
import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.api.DestinationFactory;
import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.api.http.HttpDestination;
import com.sap.core.connectivity.api.http.HttpDestinationClient;
import com.sap.core.connectivity.destinations.DestinationProviderNotFoundException;
import com.sap.core.connectivity.destinations.internal.api.ConfigurationProvider;
import com.sap.core.connectivity.destinations.internal.api.DestinationProvider;
import com.sap.core.connectivity.httpdestination.common.RuntimeUtil;
import com.sap.core.connectivity.httpdestination.internal.api.HttpClientFactory;
import com.sap.core.connectivity.httpdestination.internal.api.InvalidDestinationConfigurationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractDestinationFactory
implements DestinationFactory,
HttpClientFactory {
    protected static final RuntimeUtil RUNTIME_UTIL = new RuntimeUtil();
    private final Map<String, DestinationProvider> destinationProviders = new ConcurrentHashMap<String, DestinationProvider>();
    private ConfigurationProvider configurationProvider;

    @Override
    public HttpDestinationClient create(final DestinationConfiguration destinationConfiguration) throws InvalidDestinationConfigurationException {
        if (destinationConfiguration == null) {
            throw new InvalidDestinationConfigurationException("Destination configuration cannot be null");
        }
        ConfigurationProvider configurationProvider = new ConfigurationProvider(){

            @Override
            public DestinationConfiguration getDestinationConfiguration(String name) {
                String destinationName = destinationConfiguration.getProperty("Name");
                if (name != null && name.equals(destinationName)) {
                    return destinationConfiguration;
                }
                throw new IllegalStateException("Unexpected call to get destination with name " + name);
            }
        };
        try {
            Object destination = this.provideDestination(destinationConfiguration, configurationProvider);
            if (!(destination instanceof HttpDestination)) {
                throw new InvalidDestinationConfigurationException(String.format("Invalid destination type %s, only HTTP is supported", destinationConfiguration.getProperty("Type")));
            }
            return ((HttpDestination)destination).createHttpClient();
        }
        catch (DestinationException ex) {
            throw new InvalidDestinationConfigurationException("Cannot create http client due to a configuration issue", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidDestinationConfigurationException("Cannot create http client due to a configuration issue", ex);
        }
    }

    @Override
    public <T extends Destination> T getDestination(String destinationName) throws DestinationNotFoundException {
        return this.getDestination(destinationName, this.getConfigurationProvider());
    }

    protected <T extends Destination> T getDestination(String destinationName, ConfigurationProvider configurationProvider) throws DestinationNotFoundException {
        DestinationConfiguration configuration = configurationProvider.getDestinationConfiguration(destinationName);
        if (configuration == null) {
            throw new DestinationNotFoundException("Destination with name " + destinationName + " is not found");
        }
        return this.provideDestination(configuration, configurationProvider);
    }

    protected <T extends Destination> T provideDestination(DestinationConfiguration configuration, ConfigurationProvider configurationProvider) throws DestinationProviderNotFoundException {
        String destinationType = configuration.getProperty("Type");
        DestinationProvider destinationProvider = this.getDestinationProvider(destinationType);
        if (destinationProvider == null) {
            throw new DestinationProviderNotFoundException("Destination provider for destination type " + destinationType + " is not supported");
        }
        return destinationProvider.provideDestination(configuration, configurationProvider);
    }

    protected void addDestinationProvider(DestinationProvider destinationProvider) {
        String destinationProviderType = destinationProvider.getDestinationType();
        if (destinationProviderType != null && !destinationProviderType.isEmpty()) {
            this.destinationProviders.put(destinationProviderType.toUpperCase(), destinationProvider);
        }
    }

    protected void removeDestinationProvider(DestinationProvider destinationProvider) {
        String destinationProviderType = destinationProvider.getDestinationType();
        if (destinationProviderType != null && !destinationProviderType.isEmpty()) {
            this.destinationProviders.remove(destinationProviderType.toUpperCase());
        }
    }

    protected DestinationProvider getDestinationProvider(String destinationType) {
        if (destinationType != null) {
            Map<String, DestinationProvider> destinationProviders = this.getDestinationProviders();
            return destinationProviders.get(destinationType.toUpperCase());
        }
        return null;
    }

    private Map<String, DestinationProvider> getDestinationProviders() {
        if (this.destinationProviders.isEmpty() && !RUNTIME_UTIL.isOsgiRuntime()) {
            List<DestinationProvider> providers = RUNTIME_UTIL.loadJavaServices(DestinationProvider.class);
            for (DestinationProvider provider : providers) {
                this.addDestinationProvider(provider);
            }
        }
        return this.destinationProviders;
    }

    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    protected void unsetConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = null;
    }

    protected ConfigurationProvider getConfigurationProvider() {
        ConnectivityConfiguration connectivityConfiguration;
        if (this.configurationProvider == null && !RUNTIME_UTIL.isOsgiRuntime() && (connectivityConfiguration = RUNTIME_UTIL.loadJavaService(ConnectivityConfiguration.class, true)) != null) {
            this.setConnectivityConfiguration(connectivityConfiguration);
        }
        if (this.configurationProvider == null) {
            throw new IllegalStateException("Missing ConfigurationProvider service");
        }
        return this.configurationProvider;
    }

    protected abstract void setConnectivityConfiguration(ConnectivityConfiguration var1);
}

