/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.destinations.jndi;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.destinations.jndi.ReferenceServiceObjectFactory;
import com.sap.core.connectivity.destinations.jndi.ServiceObjectFactory;
import com.sap.core.connectivity.httpdestination.internal.api.HttpClientFactory;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;

public class JavaServiceObjectFactory
extends ServiceObjectFactory {
    private static final Logger log = Logger.getLogger(JavaServiceObjectFactory.class.getName());
    private static HttpClientFactory httpClientFactory;

    public JavaServiceObjectFactory() {
        super(JavaServiceObjectFactory.getSupportedReferences());
    }

    private static Map<String, ReferenceServiceObjectFactory.ReferenceHandler> getSupportedReferences() {
        return Collections.singletonMap(HttpClientFactory.class.getName(), new ReferenceServiceObjectFactory.ReferenceHandler(){

            @Override
            public Object getObjectInstance(Reference ref, Name name, Context nameCtx, Hashtable<?, ?> environment) throws DestinationException {
                HttpClientFactory httpClientFactory = JavaServiceObjectFactory.getHttpClientFactory();
                log.log(Level.FINE, "Will return HttpClientFactory instance : " + httpClientFactory);
                return httpClientFactory;
            }
        });
    }

    private static HttpClientFactory getHttpClientFactory() {
        if (httpClientFactory == null && !RUNTIME_UTIL.isOsgiRuntime()) {
            httpClientFactory = RUNTIME_UTIL.loadJavaService(HttpClientFactory.class);
        }
        if (httpClientFactory == null) {
            throw new IllegalStateException("Missing HttpClientFactory service");
        }
        return httpClientFactory;
    }
}

