/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.destinations.jndi;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.httpdestination.common.RuntimeUtil;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class ReferenceServiceObjectFactory
implements ObjectFactory {
    protected static final RuntimeUtil RUNTIME_UTIL = new RuntimeUtil();
    protected final Map<String, ReferenceHandler> supportedReferences;

    protected ReferenceServiceObjectFactory(Map<String, ReferenceHandler> supportedReferences) {
        this.supportedReferences = Collections.unmodifiableMap(supportedReferences);
    }

    @Override
    public final Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref;
        String className;
        if (obj instanceof Reference && (className = (ref = (Reference)obj).getClassName()) != null) {
            for (Map.Entry<String, ReferenceHandler> reference : this.supportedReferences.entrySet()) {
                if (!className.equals(reference.getKey())) continue;
                return reference.getValue().getObjectInstance(ref, name, nameCtx, environment);
            }
        }
        return null;
    }

    protected static interface ReferenceHandler {
        public Object getObjectInstance(Reference var1, Name var2, Context var3, Hashtable<?, ?> var4) throws DestinationException;
    }
}

