/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.destinations.jndi;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.api.DestinationFactory;
import com.sap.core.connectivity.api.http.HttpDestination;
import com.sap.core.connectivity.destinations.jndi.ReferenceServiceObjectFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;

public class ServiceObjectFactory
extends ReferenceServiceObjectFactory {
    private static final Logger log = Logger.getLogger(ServiceObjectFactory.class.getName());
    private static DestinationFactory destinationFactory;

    public ServiceObjectFactory() {
        super(ServiceObjectFactory.getSupportedReferences());
    }

    protected ServiceObjectFactory(Map<String, ReferenceServiceObjectFactory.ReferenceHandler> childSupportedReferences) {
        super(ServiceObjectFactory.getSupportedReferences(childSupportedReferences));
    }

    private static Map<String, ReferenceServiceObjectFactory.ReferenceHandler> getSupportedReferences() {
        HashMap<String, ReferenceServiceObjectFactory.ReferenceHandler> supportedReferences = new HashMap<String, ReferenceServiceObjectFactory.ReferenceHandler>();
        supportedReferences.put(HttpDestination.class.getName(), new ReferenceServiceObjectFactory.ReferenceHandler(){

            @Override
            public Object getObjectInstance(Reference ref, Name name, Context nameCtx, Hashtable<?, ?> environment) throws DestinationException {
                return ServiceObjectFactory.getHttpDestination(ref, name);
            }
        });
        supportedReferences.put(DestinationFactory.class.getName(), new ReferenceServiceObjectFactory.ReferenceHandler(){

            @Override
            public Object getObjectInstance(Reference ref, Name name, Context nameCtx, Hashtable<?, ?> environment) throws DestinationException {
                DestinationFactory destinationFactory = ServiceObjectFactory.getDestinationFactory();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Will return DestinationFactory instance : " + destinationFactory);
                }
                return destinationFactory;
            }
        });
        return supportedReferences;
    }

    private static Map<String, ReferenceServiceObjectFactory.ReferenceHandler> getSupportedReferences(Map<String, ReferenceServiceObjectFactory.ReferenceHandler> childSupportedReferences) {
        Map<String, ReferenceServiceObjectFactory.ReferenceHandler> supportedReferences = ServiceObjectFactory.getSupportedReferences();
        supportedReferences.putAll(childSupportedReferences);
        return supportedReferences;
    }

    private static HttpDestination getHttpDestination(Reference ref, Name name) throws DestinationException {
        String destinationName = ServiceObjectFactory.getDestinationName(ref, name);
        HttpDestination destination = (HttpDestination)ServiceObjectFactory.getDestinationFactory().getDestination(destinationName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Loaded destination with name: " + destinationName);
        }
        return destination;
    }

    private static String getDestinationName(Reference ref, Name name) throws DestinationException {
        if (name == null || name.isEmpty()) {
            throw new DestinationException("Destination name " + name + " is not configured, please use <res-ref-name>DESTINATION_NAME</res-ref-name> in web.xml or ejb-jar.xml or correct name in your annotation.");
        }
        String mappedName = null;
        String destinationName = name.toString();
        RefAddr mappedNameRefAdr = ref.get("mappedName");
        if (mappedNameRefAdr != null) {
            mappedName = (String)mappedNameRefAdr.getContent();
        }
        if (mappedName != null && mappedName.length() > 0) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Will use mappedName\"" + mappedName + "\" for the reference with ref-name \"" + destinationName + "\"");
            }
            destinationName = mappedName;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Will load destination with name: " + destinationName);
        }
        return destinationName;
    }

    private static DestinationFactory getDestinationFactory() {
        if (destinationFactory == null && !RUNTIME_UTIL.isOsgiRuntime()) {
            destinationFactory = RUNTIME_UTIL.loadJavaService(DestinationFactory.class);
        }
        if (destinationFactory == null) {
            throw new IllegalStateException("Missing DestinationFactory service");
        }
        return destinationFactory;
    }

    protected void setDestinationFactory(DestinationFactory factory) {
        destinationFactory = factory;
    }

    protected void unsetDestinationFactory(DestinationFactory factory) {
        destinationFactory = null;
    }
}

