/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.common;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.tenant.api.Tenant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class RuntimeUtil {
    private static final String OSGI_INSTALL_AREA_PROP = "osgi.install.area";
    private static final String TENANT_CLASS_NAME = "com.sap.core.tenant.api.Tenant";

    public boolean isOsgiRuntime() {
        return System.getProperty(OSGI_INSTALL_AREA_PROP) != null;
    }

    public <T> T loadJavaService(Class<T> serviceClass) {
        return this.loadJavaService(serviceClass, false);
    }

    public <T> T loadJavaService(Class<T> serviceClass, boolean useImplClassloader) {
        ServiceLoader<T> loader = this.constructServiceLoader(serviceClass, useImplClassloader);
        Iterator<T> iterator = loader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private <T> ServiceLoader<T> constructServiceLoader(Class<T> serviceClass, boolean useImplClassloader) {
        ServiceLoader<T> loader = useImplClassloader ? ServiceLoader.load(serviceClass, ClassloadingBridge.getImplClassLoader()) : ServiceLoader.load(serviceClass);
        return loader;
    }

    public Class<Tenant> loadTenantClassWithImplClassLoader() {
        try {
            return ClassloadingBridge.getImplClassLoader().loadClass(TENANT_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> List<T> loadJavaServices(Class<T> serviceClass) {
        ServiceLoader<T> loader = ServiceLoader.load(serviceClass);
        ArrayList<T> services = new ArrayList<T>();
        for (T t : loader) {
            services.add(t);
        }
        return services;
    }
}

