/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.destinations.internal.api.InternalHttpDestinationClient;
import com.sap.core.connectivity.httpdestination.common.HeaderGenerationException;
import com.sap.core.connectivity.httpdestination.common.HttpConnectionInfo;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationContext;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationHeader;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.HttpRequestExecutionCustomizer;
import com.sap.core.connectivity.httpdestination.impl.HttpClientOperation;
import com.sap.core.connectivity.httpdestination.impl.HttpConnectionInfoImpl;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationClientContext;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationSessionCookies;
import com.sap.core.connectivity.httpdestination.impl.header.SessionAwareHeader;
import com.sap.core.connectivity.httpdestination.impl.jdsr.JdsrStatistics;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractHttpClientWrapper
implements InternalHttpDestinationClient {
    private static final Logger log = Logger.getLogger(AbstractHttpClientWrapper.class.getName());
    private static final String AUTHORIZATION = "Authorization";
    protected final CloseableHttpClient httpClient;
    protected final List<HttpDestinationHeader> httpDestinationHeaders;
    protected final HttpDestinationInfo httpDestinationInfo;
    protected final HttpConnectionInfoImpl httpConnectionInfoImpl;
    protected final HttpDestinationClientContext httpClientContext;
    protected final HttpDestinationSessionCookies httpDestinationSessionCookies;
    protected final HttpRequestExecutionCustomizer httpRequestExecutionCustomizer;

    protected AbstractHttpClientWrapper(CloseableHttpClient httpClient, HttpDestinationClientContext httpClientContext) {
        this(httpClient, httpClientContext, httpClientContext.getHttpDestinationInfo().getHeaders());
    }

    protected AbstractHttpClientWrapper(CloseableHttpClient httpClient, HttpDestinationClientContext httpClientContext, List<HttpDestinationHeader> httpDestinationHeaders) {
        if (httpDestinationHeaders == null) {
            throw new IllegalArgumentException("Null value was supplied for the header list. At least empty list is needed.");
        }
        this.httpClient = httpClient;
        this.httpDestinationInfo = httpClientContext.getHttpDestinationInfo();
        this.httpDestinationHeaders = this.processHttpDestinationHeaders(httpDestinationHeaders);
        this.httpConnectionInfoImpl = new HttpConnectionInfoImpl();
        this.httpRequestExecutionCustomizer = httpClientContext.getHttpRequestExecutionCustomizer();
        this.httpClientContext = httpClientContext;
        String[] sessionCookieNames = this.getSessionCookieNames();
        if (sessionCookieNames != null && sessionCookieNames.length > 0) {
            this.httpDestinationSessionCookies = new HttpDestinationSessionCookies(sessionCookieNames);
            httpClientContext.setCookieStore((CookieStore)new BasicCookieStore());
        } else {
            this.httpDestinationSessionCookies = null;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "No custom defined session cookies specified and the client is not session aware");
            }
        }
    }

    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public final String getDestinationName() {
        return this.httpDestinationInfo.getName();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.execute(request, (HttpContext)null);
    }

    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        HttpClientOperation<CloseableHttpResponse> operation = this.createOperation(request);
        return this.execute(operation, context);
    }

    protected HttpClientOperation<CloseableHttpResponse> createOperation(final HttpUriRequest request) {
        return new HttpClientOperation<CloseableHttpResponse>(){

            @Override
            public CloseableHttpResponse execute(HttpContext context) throws IOException {
                return AbstractHttpClientWrapper.this.httpClient.execute(AbstractHttpClientWrapper.this.convertHttpUriRequest(request, context), context);
            }
        };
    }

    public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.execute(target, request, (HttpContext)null);
    }

    public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        HttpClientOperation<CloseableHttpResponse> operation = this.createOperation(target, request);
        return this.execute(operation, context);
    }

    protected HttpClientOperation<CloseableHttpResponse> createOperation(final HttpHost target, final HttpRequest request) {
        return new HttpClientOperation<CloseableHttpResponse>(){

            @Override
            public CloseableHttpResponse execute(HttpContext context) throws IOException {
                return AbstractHttpClientWrapper.this.httpClient.execute(AbstractHttpClientWrapper.this.convertHttpHost(target), AbstractHttpClientWrapper.this.convertHttpRequest(request, context), context);
            }
        };
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(request, responseHandler, null);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpClientOperation<? extends T> operation = this.createOperation(request, responseHandler);
        return this.execute(operation, context);
    }

    protected <T> HttpClientOperation<T> createOperation(final HttpUriRequest request, final ResponseHandler<? extends T> responseHandler) {
        return new HttpClientOperation<T>(){

            @Override
            public T execute(HttpContext context) throws IOException {
                return AbstractHttpClientWrapper.this.httpClient.execute(AbstractHttpClientWrapper.this.convertHttpUriRequest(request, context), responseHandler, context);
            }
        };
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(target, request, responseHandler, null);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpClientOperation<? extends T> operation = this.createOperation(target, request, responseHandler);
        return this.execute(operation, context);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    protected <T> HttpClientOperation<T> createOperation(final HttpHost target, final HttpRequest request, final ResponseHandler<? extends T> responseHandler) {
        return new HttpClientOperation<T>(){

            @Override
            public T execute(HttpContext context) throws IOException {
                return AbstractHttpClientWrapper.this.httpClient.execute(AbstractHttpClientWrapper.this.convertHttpHost(target), AbstractHttpClientWrapper.this.convertHttpRequest(request, context), responseHandler, context);
            }
        };
    }

    protected HttpUriRequest convertHttpUriRequest(HttpUriRequest request, HttpContext context) throws ClientProtocolException {
        return (HttpUriRequest)this.convertHttpRequest((HttpRequest)request, request.getURI(), context);
    }

    protected HttpRequest convertHttpRequest(HttpRequest request, HttpContext context) throws ClientProtocolException {
        try {
            URI uri = request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : new URI(request.getRequestLine().getUri());
            return this.convertHttpRequest(request, uri, context);
        }
        catch (URISyntaxException ex) {
            throw new ClientProtocolException("Invalid request URI", (Throwable)ex);
        }
    }

    protected HttpRequest convertHttpRequest(HttpRequest request, URI uri, HttpContext context) throws ClientProtocolException {
        this.setRequestConfig(request, context);
        URI processRequestURI = this.convertRequestURIAccordingToDestinationUri(uri);
        HttpRequestWrapper requestWrapper = HttpRequestWrapper.wrap((HttpRequest)request);
        requestWrapper.setURI(processRequestURI);
        this.removeAuthorizationHeaders((HttpRequest)requestWrapper);
        this.injectHeaders((HttpRequest)requestWrapper, context);
        return requestWrapper;
    }

    private void setRequestConfig(HttpRequest request, HttpContext context) {
        RequestConfig config;
        if (request instanceof Configurable && (config = ((Configurable)request).getConfig()) != null) {
            context.setAttribute("http.request-config", (Object)config);
        }
    }

    protected void removeAuthorizationHeaders(HttpRequest request) {
        String authType = this.httpDestinationInfo.getProperty("Authentication");
        if ("BasicAuthentication".equals(authType)) {
            request.removeHeaders(AUTHORIZATION);
        }
    }

    protected void injectHeaders(HttpRequest request, HttpContext context) {
        for (HttpDestinationHeader httpDestinationHeader : this.httpDestinationHeaders) {
            try {
                httpDestinationHeader.inject(this.httpConnectionInfoImpl, request, context);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("System headers cannot be generated due to : " + ex.toString(), new HeaderGenerationException(ex.getMessage(), ex.getCause()));
            }
        }
    }

    protected abstract URI convertRequestURIAccordingToDestinationUri(URI var1);

    protected abstract HttpHost convertHttpHost(HttpHost var1);

    protected <T> T execute(HttpClientOperation<T> operation, HttpContext context) throws IOException {
        return this.executeOperation(operation, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T executeOperation(HttpClientOperation<T> operation, HttpContext context) throws IOException {
        HttpDestinationContext executionContext;
        if (context == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Default HTTP Context will be used for execution of the operation");
            }
            executionContext = this.httpClientContext;
        } else {
            executionContext = this.httpClientContext.createHttpDestinationContext(context);
        }
        if (this.httpRequestExecutionCustomizer != null) {
            this.httpRequestExecutionCustomizer.customizeRequest(executionContext);
        }
        long timeBeforeExecution = System.currentTimeMillis();
        try {
            T t = operation.execute(executionContext);
            return t;
        }
        finally {
            this.updateJdsrStatistics(System.currentTimeMillis() - timeBeforeExecution);
            this.httpConnectionInfoImpl.removeCounter();
        }
    }

    private void updateJdsrStatistics(long executionDurationInMillis) {
        if (this.shouldCollectJdsr()) {
            JdsrStatistics.getInstance().addExternalRecord(executionDurationInMillis, this.httpConnectionInfoImpl, this.httpDestinationInfo);
        }
    }

    protected boolean shouldCollectJdsr() {
        return JdsrStatistics.getInstance().shouldCollectData();
    }

    private String[] getSessionCookieNames() {
        String sessionCookieNames = this.httpDestinationInfo.getProperties().getProperty("SessionCookieNames");
        if (sessionCookieNames != null) {
            StringTokenizer st = new StringTokenizer(sessionCookieNames, ",");
            HashSet<String> out = new HashSet<String>(st.countTokens());
            while (st.hasMoreElements()) {
                String sessionCookieName = st.nextToken().trim();
                if (sessionCookieName.isEmpty()) continue;
                out.add(sessionCookieName);
            }
            return out.toArray(new String[out.size()]);
        }
        return null;
    }

    private List<HttpDestinationHeader> processHttpDestinationHeaders(List<HttpDestinationHeader> httpDestinationHeaders) {
        ArrayList<HttpDestinationHeader> resHttpDestinationHeaders = new ArrayList<HttpDestinationHeader>(httpDestinationHeaders.size());
        Iterator<HttpDestinationHeader> iterator = httpDestinationHeaders.iterator();
        while (iterator.hasNext()) {
            HttpDestinationHeader httpDestinationHeader;
            HttpDestinationHeader resHttpDestinationHeader = httpDestinationHeader = iterator.next();
            if (httpDestinationHeader instanceof SessionAwareHeader) {
                resHttpDestinationHeader = new SessionAwareHeaderWrapper((SessionAwareHeader)httpDestinationHeader);
            }
            resHttpDestinationHeaders.add(resHttpDestinationHeader);
        }
        return resHttpDestinationHeaders;
    }

    private boolean areSessionCookiesAvailable(HttpContext context) {
        if (this.httpDestinationSessionCookies != null && context != null) {
            CookieStore cookieStore = (CookieStore)context.getAttribute("http.cookie-store");
            return this.httpDestinationSessionCookies.containedIn(cookieStore);
        }
        return false;
    }

    @Override
    public boolean isConnectionPoolingSupported() {
        return this.httpClientContext.isConnectionPoolingSupported();
    }

    private class SessionAwareHeaderWrapper
    implements SessionAwareHeader {
        private final SessionAwareHeader sessionAwareHeader;

        private SessionAwareHeaderWrapper(SessionAwareHeader sessionAwareHeader) {
            this.sessionAwareHeader = sessionAwareHeader;
        }

        @Override
        public void inject(HttpConnectionInfo connectionInfo, HttpRequest request, HttpContext context) {
            if (!AbstractHttpClientWrapper.this.areSessionCookiesAvailable(context)) {
                this.sessionAwareHeader.inject(connectionInfo, request, context);
            } else if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session cookies available and headers will not be injected");
            }
        }
    }
}

