/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.api.authentication.AuthenticationHeaderProvider;
import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.api.http.HttpDestination;
import com.sap.core.connectivity.api.sappassport.SapPassportHeaderProvider;
import com.sap.core.connectivity.destinations.DefaultConfigurationProvider;
import com.sap.core.connectivity.destinations.internal.api.ConfigurationProvider;
import com.sap.core.connectivity.destinations.internal.api.DestinationProvider;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationService;
import com.sap.core.connectivity.httpdestination.common.RuntimeUtil;
import com.sap.core.connectivity.httpdestination.common.onpremise.OnPremiseConfigurator;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationImpl;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationInfoDelegate;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationInfoProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractHttpDestinationService
implements HttpDestinationService,
DestinationProvider {
    private static final Logger log = Logger.getLogger(AbstractHttpDestinationService.class.getName());
    private static final RuntimeUtil RUNTIME_UTIL = new RuntimeUtil();
    private static final String DESTINATION_TYPE_HTTP = "HTTP";
    private ConfigurationProvider configurationProvider;
    private HttpDestinationInfoProvider destinationInfoProvider;
    protected AuthenticationHeaderProvider authenticationHeaderProvider;
    protected SapPassportHeaderProvider sapPassportHeaderProvider;

    @Override
    public String getDestinationType() {
        return DESTINATION_TYPE_HTTP;
    }

    public HttpDestination provideDestination(DestinationConfiguration configuration, ConfigurationProvider configurationProvider) {
        try {
            String destinationName = configuration.getProperty("Name");
            return this.getDestination(destinationName, configurationProvider, false);
        }
        catch (DestinationNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public HttpDestination getHttpDestination(String destinationName) {
        try {
            return this.getDestination(destinationName, this.getConfigurationProvider(), true);
        }
        catch (DestinationNotFoundException ex) {
            return null;
        }
    }

    protected HttpDestination getDestination(String name, ConfigurationProvider configurationProvider, boolean check) throws DestinationNotFoundException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Will get HttpDestination with name: " + name);
        }
        HttpDestinationInfoDelegate httpDestinationInfoDelegate = new HttpDestinationInfoDelegate(name, configurationProvider, this.getDestinationInfoProvider());
        if (check) {
            httpDestinationInfoDelegate.getHttpDestinationInfo();
        }
        HttpDestination httpDestination = this.createHttpDestination(httpDestinationInfoDelegate);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "HttpDestination with name: " + name + " was created.");
        }
        return httpDestination;
    }

    protected HttpDestination createHttpDestination(HttpDestinationInfoDelegate httpDestinationInfoDelegate) {
        return new HttpDestinationImpl(httpDestinationInfoDelegate, this.getOnPremiseConfigurator(httpDestinationInfoDelegate));
    }

    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    protected ConfigurationProvider getConfigurationProvider() {
        ConnectivityConfiguration configuration;
        if (this.configurationProvider == null && (configuration = RUNTIME_UTIL.loadJavaService(ConnectivityConfiguration.class, true)) != null) {
            this.setConfigurationProvider(new DefaultConfigurationProvider(configuration));
        }
        if (this.configurationProvider == null) {
            throw new IllegalStateException("Missing ConfigurationProvider service");
        }
        return this.configurationProvider;
    }

    protected void setDestinationInfoProvider(HttpDestinationInfoProvider destinationInfoProvider) {
        this.destinationInfoProvider = destinationInfoProvider;
    }

    protected HttpDestinationInfoProvider getDestinationInfoProvider() {
        if (this.destinationInfoProvider == null) {
            this.activate();
        }
        return this.destinationInfoProvider;
    }

    protected OnPremiseConfigurator getOnPremiseConfigurator(HttpDestinationInfoDelegate infoDelegate) {
        throw new UnsupportedOperationException("This method should not be used");
    }

    protected AuthenticationHeaderProvider getAuthenticationHeaderProvider() {
        if (this.authenticationHeaderProvider == null) {
            this.authenticationHeaderProvider = RUNTIME_UTIL.loadJavaService(AuthenticationHeaderProvider.class, true);
        }
        if (this.authenticationHeaderProvider == null) {
            throw new IllegalStateException("Missing AuthenticationHeaderProvider service");
        }
        return this.authenticationHeaderProvider;
    }

    protected SapPassportHeaderProvider getSapPassportHeaderProvider() {
        if (this.sapPassportHeaderProvider == null) {
            this.sapPassportHeaderProvider = RUNTIME_UTIL.loadJavaService(SapPassportHeaderProvider.class, true);
        }
        if (this.sapPassportHeaderProvider == null) {
            throw new IllegalStateException("Missing SapPassportHeaderProvider service");
        }
        return this.sapPassportHeaderProvider;
    }

    protected abstract void activate();
}

