/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import java.util.concurrent.TimeUnit;
import org.apache.http.config.Registry;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class DestinationClientConnectionManager
extends PoolingHttpClientConnectionManager {
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS_VALUE = 20;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE_VALUE = 2;

    public DestinationClientConnectionManager(HttpDestinationInfo destinationInfo) {
        this.configure(destinationInfo);
    }

    public DestinationClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, long timeToLive, TimeUnit timeUnit, HttpDestinationInfo destinationInfo) {
        super(httpClientConnectionOperator, connFactory, timeToLive, timeUnit);
        this.configure(destinationInfo);
    }

    public DestinationClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry, HttpDestinationInfo destinationInfo) {
        super(socketFactoryRegistry);
        this.configure(destinationInfo);
    }

    public void configure(HttpDestinationInfo destinationInfo) {
        if (destinationInfo.getProperties() == null) {
            return;
        }
        if (destinationInfo.getProperty("maxTotalConnections") == null) {
            this.setMaxTotal(20);
        } else {
            this.setMaxTotal(Integer.valueOf(destinationInfo.getProperty("maxTotalConnections")));
        }
        if (destinationInfo.getProperty("defaultMaxConnectionsPerRoute") == null) {
            this.setDefaultMaxPerRoute(2);
        } else {
            this.setDefaultMaxPerRoute(Integer.valueOf(destinationInfo.getProperty("defaultMaxConnectionsPerRoute")));
        }
    }
}

