/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.httpdestination.impl.AbstractHttpClientWrapper;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationClientContext;
import com.sap.core.connectivity.httpdestination.impl.utils.HttpDestinationInfoUtils;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpClientWrapper
extends AbstractHttpClientWrapper {
    public HttpClientWrapper(CloseableHttpClient httpClient, HttpDestinationClientContext httpClientContext) {
        super(httpClient, httpClientContext);
    }

    @Override
    protected URI convertRequestURIAccordingToDestinationUri(URI requestURI) {
        try {
            return HttpDestinationInfoUtils.convertUrl(requestURI, this.httpDestinationInfo);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Request URI cannot be converted according to destination URI", ex);
        }
    }

    @Override
    protected HttpHost convertHttpHost(HttpHost target) {
        HttpHost convertedTarget = target;
        try {
            if (this.targetHostIsEmpty(target)) {
                convertedTarget = this.getHttpHostFromDestinationUrl();
            } else {
                this.checkHost(convertedTarget, new URI(this.httpDestinationInfo.getDestinationUrl()));
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Unable to parse destination URL", ex);
        }
        return convertedTarget;
    }

    private boolean targetHostIsEmpty(HttpHost target) {
        return target == null || target.toHostString() == null || target.toHostString().isEmpty();
    }

    private void checkHost(HttpHost host, URI uri) {
        if (!uri.getHost().equals(host.getHostName())) {
            throw new IllegalArgumentException(String.format("Supplied host name %s is not the same as in the destination, where it is %s", host.getHostName(), uri.getHost()));
        }
        if (uri.getPort() != host.getPort()) {
            throw new IllegalArgumentException(String.format("Supplied port %s is not the same as in the destination, where it is %s", host.getPort(), uri.getPort()));
        }
        if (!uri.getScheme().equals(host.getSchemeName())) {
            throw new IllegalArgumentException(String.format("Supplied scheme name %s is not the same as in the destination, where it is %s", host.getSchemeName(), uri.getScheme()));
        }
    }

    private HttpHost getHttpHostFromDestinationUrl() throws URISyntaxException {
        URI uri = new URI(this.httpDestinationInfo.getDestinationUrl());
        return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }
}

