/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.httpdestination.common.HttpConnectionInfo;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

class HttpConnectionInfoImpl
implements HttpConnectionInfo {
    private byte[] id = null;
    private AtomicInteger counters = new AtomicInteger(0);
    private ThreadLocal<Integer> counter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return HttpConnectionInfoImpl.this.counters.incrementAndGet();
        }
    };

    HttpConnectionInfoImpl() {
    }

    public synchronized byte[] getId() {
        if (this.id == null) {
            this.id = this.getBytesFromUUID(UUID.randomUUID());
        }
        return Arrays.copyOf(this.id, this.id.length);
    }

    public int getCounter() {
        return this.counter.get();
    }

    public void removeCounter() {
        this.counter.remove();
    }

    private byte[] getBytesFromUUID(UUID uuid) {
        ByteBuffer bBuf = ByteBuffer.wrap(new byte[16]);
        bBuf.putLong(uuid.getMostSignificantBits());
        bBuf.putLong(uuid.getLeastSignificantBits());
        return bBuf.array();
    }
}

