/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationAuthenticator;
import com.sap.core.connectivity.httpdestination.impl.auth.BasicAuthenticator;
import com.sap.core.connectivity.httpdestination.impl.auth.ClientCertAuthenticator;
import com.sap.core.connectivity.httpdestination.impl.auth.EmptyAuthenticator;
import com.sap.core.connectivity.httpdestination.impl.auth.OAuth2ClientCredentialsAuthenticator;
import com.sap.core.connectivity.httpdestination.impl.auth.OAuth2SAMLBearerAssertionAuthenticator;
import com.sap.core.connectivity.httpdestination.impl.auth.SAMLApp2AppAuthenticator;
import com.sap.core.connectivity.httpdestination.impl.auth.SAPAssertionAuthenticator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpDestinationAuthenticatorProvider {
    private static Logger log = Logger.getLogger(HttpDestinationAuthenticatorProvider.class.getName());
    private static final String SAML2_ASSERTION = "SAML2Assertion";
    private final Map<String, HttpDestinationAuthenticator> authenticators = new HashMap<String, HttpDestinationAuthenticator>();

    public HttpDestinationAuthenticatorProvider() {
        this.registerDefaultAuthenticators();
    }

    public HttpDestinationAuthenticatorProvider(HttpDestinationAuthenticator ... customAuthenticators) {
        this.registerDefaultAuthenticators();
        if (customAuthenticators != null) {
            for (HttpDestinationAuthenticator authenticator : customAuthenticators) {
                this.registerAuthenticator(authenticator);
            }
        }
    }

    public HttpDestinationAuthenticator getAuthenticator(DestinationConfiguration configuration) {
        String type = configuration.getProperty("Authentication");
        if (SAML2_ASSERTION.equalsIgnoreCase(type)) {
            log.log(Level.WARNING, "SAML2Assertion authentication type is not supported");
            return null;
        }
        HttpDestinationAuthenticator authenticator = this.authenticators.get(type);
        if (authenticator == null) {
            throw new IllegalArgumentException("There is no registered authenticator for authentication type '" + type + "'");
        }
        return authenticator;
    }

    private void registerAuthenticator(HttpDestinationAuthenticator authenticator) {
        this.authenticators.put(authenticator.getType(), authenticator);
    }

    private void registerDefaultAuthenticators() {
        this.registerAuthenticator(new EmptyAuthenticator());
        this.registerAuthenticator(new SAMLApp2AppAuthenticator());
        this.registerAuthenticator(new SAPAssertionAuthenticator());
        this.registerAuthenticator(new BasicAuthenticator());
        this.registerAuthenticator(new OAuth2SAMLBearerAssertionAuthenticator());
        this.registerAuthenticator(new OAuth2ClientCredentialsAuthenticator());
        this.registerAuthenticator(new ClientCertAuthenticator());
    }
}

