/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.api.authentication.AuthenticationHeaderProvider;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.api.sappassport.SapPassportHeaderProvider;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationHeader;
import com.sap.core.connectivity.httpdestination.impl.header.OAuth2ClientCredentialsAuthenticationHeader;
import com.sap.core.connectivity.httpdestination.impl.header.OAuth2SAMLBearerAssertionHeader;
import com.sap.core.connectivity.httpdestination.impl.header.SAMLApp2AppHeader;
import com.sap.core.connectivity.httpdestination.impl.header.SAPAssertionHeader;
import com.sap.core.connectivity.httpdestination.impl.header.SAPPassportHeader;
import java.util.ArrayList;
import java.util.List;

public class HttpDestinationHeadersProvider {
    private final AuthenticationHeaderProvider authenticationHeaderProvider;
    private final SapPassportHeaderProvider sapPassportHeaderProvider;

    public HttpDestinationHeadersProvider(AuthenticationHeaderProvider authenticationHeaderProvider, SapPassportHeaderProvider sapPassportHeaderProvider) {
        this.authenticationHeaderProvider = authenticationHeaderProvider;
        this.sapPassportHeaderProvider = sapPassportHeaderProvider;
    }

    public List<HttpDestinationHeader> getHeaders(DestinationConfiguration configuration) {
        ArrayList<HttpDestinationHeader> headerProviders = new ArrayList<HttpDestinationHeader>();
        headerProviders.add(new SAPPassportHeader(this.sapPassportHeaderProvider));
        String authenticationType = configuration.getProperty("Authentication");
        if ("OAuth2SAMLBearerAssertion".equals(authenticationType)) {
            headerProviders.add(new OAuth2SAMLBearerAssertionHeader(this.authenticationHeaderProvider, configuration));
        } else if ("SAPAssertionSSO".equals(authenticationType)) {
            headerProviders.add(new SAPAssertionHeader(this.authenticationHeaderProvider, configuration));
        } else if ("AppToAppSSO".equals(authenticationType)) {
            headerProviders.add(new SAMLApp2AppHeader(this.authenticationHeaderProvider, configuration));
        } else if ("OAuth2ClientCredentials".equals(authenticationType)) {
            headerProviders.add(new OAuth2ClientCredentialsAuthenticationHeader(this.authenticationHeaderProvider, configuration));
        }
        return headerProviders;
    }
}

