/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.api.http.HttpDestination;
import com.sap.core.connectivity.api.http.HttpDestinationClient;
import com.sap.core.connectivity.httpdestination.common.HttpClientBuilderWrapper;
import com.sap.core.connectivity.httpdestination.common.HttpClientConfigurator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationContext;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.HttpRequestExecutionCustomizer;
import com.sap.core.connectivity.httpdestination.common.onpremise.OnPremiseConfigurator;
import com.sap.core.connectivity.httpdestination.impl.DefaultHttpRequestExecutionCustomizer;
import com.sap.core.connectivity.httpdestination.impl.HttpClientBuilderWrapperImpl;
import com.sap.core.connectivity.httpdestination.impl.HttpClientWrapper;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationClientContext;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationInfoDelegate;
import com.sap.core.connectivity.httpdestination.impl.apptoappsso.HttpAppToAppSsoClientWrapper;
import com.sap.core.connectivity.httpdestination.impl.configurator.AuthenticatorConfigurator;
import com.sap.core.connectivity.httpdestination.impl.configurator.ProxyConfigurator;
import com.sap.core.connectivity.httpdestination.impl.configurator.RequestConfigurator;
import com.sap.core.connectivity.httpdestination.impl.configurator.RequestInterceptorConfigurator;
import com.sap.core.connectivity.httpdestination.impl.configurator.ResponseInterceptorConfigurator;
import com.sap.core.connectivity.httpdestination.impl.configurator.URLHeaderConfigurator;
import com.sap.core.connectivity.httpdestination.impl.s2s.HttpS2SClientWrapper;
import com.sap.core.connectivity.httpdestination.impl.utils.HttpDestinationInfoUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpDestinationImpl
implements HttpDestination {
    private final Logger logger = Logger.getLogger(HttpDestinationImpl.class.getName());
    private final HttpDestinationInfoDelegate destinationInfoDelegate;
    private final OnPremiseConfigurator onPremiseConfigurator;

    public HttpDestinationImpl(HttpDestinationInfoDelegate httpDestinationInfoDelegate) {
        this(httpDestinationInfoDelegate, null);
    }

    public HttpDestinationImpl(HttpDestinationInfoDelegate httpDestinationInfoDelegate, OnPremiseConfigurator onPremiseConfigurator) {
        this.destinationInfoDelegate = httpDestinationInfoDelegate;
        this.onPremiseConfigurator = onPremiseConfigurator;
    }

    public HttpDestinationClient createHttpClient(HttpClientConfigurator configurator) throws DestinationException {
        try {
            HttpDestinationInfo httpDestinationInfo = this.destinationInfoDelegate.getHttpDestinationInfo();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, String.format("Will create client for destination: %s", httpDestinationInfo.getName()));
            }
            if (this.isDirectS2SEnabled(httpDestinationInfo)) {
                return this.createDirectS2SHttpClient(httpDestinationInfo, configurator);
            }
            return this.createHttpClientWrapper(httpDestinationInfo, configurator);
        }
        catch (IllegalArgumentException ex) {
            throw new DestinationException("Http client cannot be created", ex);
        }
    }

    @Override
    public HttpDestinationClient createHttpClient() throws DestinationException {
        return this.createHttpClient(null);
    }

    @Override
    public String getName() {
        Properties destinationProperties = this.readDestinationProperties();
        return destinationProperties.getProperty("Name");
    }

    @Override
    public URI getURI() throws URISyntaxException {
        return new URI(this.getDestinationUrl());
    }

    public String getDestinationUrl() {
        Properties destinationProperties = this.readDestinationProperties();
        return destinationProperties.getProperty("URL");
    }

    private boolean isDirectS2SEnabled(HttpDestinationInfo httpDestinationInfo) {
        String authType = httpDestinationInfo.getProperty("Authentication");
        return authType.equals("InternalSystemAuthentication") && httpDestinationInfo.getProperties().getProperty("EnableDirectCommunication", "false").equalsIgnoreCase("true");
    }

    private HttpDestinationClient createDirectS2SHttpClient(HttpDestinationInfo httpDestinationInfo, HttpClientConfigurator configurator) throws DestinationException {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        HttpClientBuilderWrapper httpClientBuilder = HttpClientBuilderWrapperImpl.create();
        this.configureHttpClient(httpClientBuilder, httpDestinationInfo, (CredentialsProvider)credentialsProvider, configurator, true);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpDestinationClientContextImpl httpClientContext = new HttpDestinationClientContextImpl(httpDestinationInfo, new DefaultHttpRequestExecutionCustomizer(), (CredentialsProvider)credentialsProvider);
        HttpClientBuilderWrapper discoveryHttpClientBuilder = HttpClientBuilderWrapperImpl.create();
        this.configureHttpClient(discoveryHttpClientBuilder, httpDestinationInfo, (CredentialsProvider)new BasicCredentialsProvider(), null, false);
        CloseableHttpClient discoveryClient = discoveryHttpClientBuilder.build();
        return new HttpS2SClientWrapper(httpClient, (HttpDestinationClientContext)httpClientContext, discoveryClient);
    }

    private boolean isConnectionPoolingSupported(HttpDestinationInfo info) {
        if (HttpDestinationInfoUtils.isOnPremiseDestination(info)) {
            return this.onPremiseConfigurator.isConnectionPoolingSupported();
        }
        return false;
    }

    private HttpDestinationClient createHttpClientWrapper(HttpDestinationInfo httpDestinationInfo, HttpClientConfigurator configurator) throws DestinationException {
        HttpRequestExecutionCustomizer httpRequestExecutionCustomizer;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        HttpClientBuilderWrapper httpClientBuilder = HttpClientBuilderWrapperImpl.create();
        this.configureHttpClient(httpClientBuilder, httpDestinationInfo, (CredentialsProvider)credentialsProvider, configurator, true);
        if (HttpDestinationInfoUtils.isOnPremiseDestination(httpDestinationInfo)) {
            this.onPremiseConfigurator.configure(httpClientBuilder, httpDestinationInfo);
            httpRequestExecutionCustomizer = this.onPremiseConfigurator.createRequestExecutionCustomizer(httpDestinationInfo);
        } else {
            httpRequestExecutionCustomizer = new DefaultHttpRequestExecutionCustomizer();
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return this.createHttpClientWrapperWithCustomizer(httpClient, httpDestinationInfo, httpRequestExecutionCustomizer, (CredentialsProvider)credentialsProvider);
    }

    private HttpClientWrapper createHttpClientWrapperWithCustomizer(CloseableHttpClient httpClient, HttpDestinationInfo httpDestinationInfo, HttpRequestExecutionCustomizer httpRequestExecutionCustomizer, CredentialsProvider credentialsProvider) {
        HttpDestinationClientContextImpl httpClientContext = new HttpDestinationClientContextImpl(httpDestinationInfo, httpRequestExecutionCustomizer, credentialsProvider);
        String authType = httpDestinationInfo.getProperty("Authentication");
        if ("AppToAppSSO".equals(authType)) {
            return new HttpAppToAppSsoClientWrapper(httpClient, httpClientContext);
        }
        return new HttpClientWrapper(httpClient, httpClientContext);
    }

    protected void configureHttpClient(HttpClientBuilderWrapper httpClientBuilder, HttpDestinationInfo httpDestinationInfo, CredentialsProvider credentialsProvider, HttpClientConfigurator customConfigurator, boolean configureTimeouts) throws DestinationException {
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        ArrayList<HttpClientConfigurator> configurators = new ArrayList<HttpClientConfigurator>();
        configurators.add(new ProxyConfigurator(credentialsProvider));
        configurators.add(new AuthenticatorConfigurator(credentialsProvider));
        configurators.add(new RequestConfigurator(configureTimeouts));
        configurators.add(new RequestInterceptorConfigurator());
        configurators.add(new ResponseInterceptorConfigurator());
        configurators.add(new URLHeaderConfigurator());
        if (customConfigurator != null) {
            configurators.add(customConfigurator);
        }
        for (HttpClientConfigurator configurator : configurators) {
            configurator.configure(httpClientBuilder, httpDestinationInfo);
        }
    }

    private Properties readDestinationProperties() {
        try {
            HttpDestinationInfo httpDestinationInfo = this.destinationInfoDelegate.getHttpDestinationInfo();
            return httpDestinationInfo.getProperties();
        }
        catch (DestinationNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private class HttpDestinationClientContextImpl
    extends HttpDestinationClientContext {
        private final HttpDestinationInfo httpDestinationInfo;
        private final HttpRequestExecutionCustomizer httpRequestExecutionCustomizer;
        private final CredentialsProvider defaultCredentialsProvider;

        private HttpDestinationClientContextImpl(HttpDestinationInfo httpDestinationInfo, HttpRequestExecutionCustomizer httpRequestExecutionCustomizer, CredentialsProvider defaultCredentialsProvider) {
            this((HttpContext)new BasicHttpContext(), httpDestinationInfo, httpRequestExecutionCustomizer, defaultCredentialsProvider);
        }

        private HttpDestinationClientContextImpl(HttpContext httpContext, HttpDestinationInfo httpDestinationInfo, HttpRequestExecutionCustomizer httpRequestExecutionCustomizer, CredentialsProvider defaultCredentialsProvider) {
            super(httpContext);
            this.httpDestinationInfo = httpDestinationInfo;
            this.httpRequestExecutionCustomizer = httpRequestExecutionCustomizer;
            this.defaultCredentialsProvider = defaultCredentialsProvider;
        }

        @Override
        public HttpDestinationInfo getHttpDestinationInfo() {
            return this.httpDestinationInfo;
        }

        @Override
        public CredentialsProvider getDefaultCredentialsProvider() {
            return this.defaultCredentialsProvider;
        }

        @Override
        public boolean isConnectionPoolingSupported() {
            return HttpDestinationImpl.this.isConnectionPoolingSupported(this.httpDestinationInfo);
        }

        @Override
        public HttpRequestExecutionCustomizer getHttpRequestExecutionCustomizer() {
            return this.httpRequestExecutionCustomizer;
        }

        @Override
        public HttpDestinationContext createHttpDestinationContext(HttpContext httpContext) {
            return new HttpDestinationClientContextImpl(httpContext, this.httpDestinationInfo, this.httpRequestExecutionCustomizer, this.defaultCredentialsProvider);
        }
    }
}

