/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.RuntimeUtil;
import com.sap.core.tenant.api.Tenant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpDestinationInfoCache {
    private static Logger log = Logger.getLogger(HttpDestinationInfoCache.class.getName());
    private final ConcurrentHashMap<String, HttpDestinationInfo> httpDestinationInfoCache = new ConcurrentHashMap();
    private final RuntimeUtil runtimeUtil = new RuntimeUtil();

    public HttpDestinationInfo getDestinationInfo(String name) {
        HttpDestinationInfo info = this.httpDestinationInfoCache.get(name);
        if (info == null) {
            if (this.runtimeUtil.isOsgiRuntime()) {
                boolean isTenantAvailable = Tenant.isAvailable();
                if (isTenantAvailable) {
                    String id = Tenant.getId();
                    info = this.httpDestinationInfoCache.get(id + "/" + name);
                }
            } else if (this.isTenantAvailable().booleanValue()) {
                String id = this.getTenantId();
                info = this.httpDestinationInfoCache.get(id + "/" + name);
            }
        }
        return info;
    }

    private Boolean isTenantAvailable() {
        Class<Tenant> tenantClass = this.runtimeUtil.loadTenantClassWithImplClassLoader();
        try {
            return (Boolean)tenantClass.getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String getTenantId() {
        Class<Tenant> tenantClass = this.runtimeUtil.loadTenantClassWithImplClassLoader();
        try {
            return (String)tenantClass.getMethod("getId", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void saveDestinationInfo(String name, HttpDestinationInfo info, boolean isTenantAware) {
        String nameInCache = name;
        if (this.runtimeUtil.isOsgiRuntime()) {
            if (isTenantAware && Tenant.isAvailable()) {
                nameInCache = Tenant.getId() + "/" + name;
            }
        } else if (isTenantAware && this.isTenantAvailable().booleanValue()) {
            nameInCache = this.getTenantId() + "/" + name;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("Putting into cache destination with name '%s'", nameInCache));
        }
        this.httpDestinationInfoCache.put(nameInCache, info);
    }

    public void clearCache() {
        this.httpDestinationInfoCache.clear();
    }
}

