/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.destinations.internal.api.AccountConfigurationProvider;
import com.sap.core.connectivity.destinations.internal.api.ConfigurationProvider;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationInfoProvider;

public class HttpDestinationInfoDelegate {
    private final String destinationName;
    private final String destinationAccount;
    private final HttpDestinationInfoProvider destinationInfoProvider;
    private final ConfigurationProvider configurationProvider;
    private final HttpDestinationInfo destinationInfo;

    public HttpDestinationInfoDelegate(String destinationName, ConfigurationProvider configurationProvider, HttpDestinationInfoProvider destinationInfoProvider) {
        this.destinationName = destinationName;
        this.configurationProvider = configurationProvider;
        this.destinationInfoProvider = destinationInfoProvider;
        this.destinationInfo = null;
        if (configurationProvider instanceof AccountConfigurationProvider) {
            AccountConfigurationProvider accConfProv = (AccountConfigurationProvider)configurationProvider;
            this.destinationAccount = accConfProv.getDestinationAccount();
        } else {
            this.destinationAccount = null;
        }
    }

    private HttpDestinationInfoDelegate(HttpDestinationInfo destinationInfo) {
        this.destinationName = null;
        this.destinationAccount = null;
        this.configurationProvider = null;
        this.destinationInfoProvider = null;
        this.destinationInfo = destinationInfo;
    }

    public HttpDestinationInfo getHttpDestinationInfo() throws DestinationNotFoundException {
        if (this.destinationInfo != null) {
            return this.destinationInfo;
        }
        return this.destinationInfoProvider.getHttpDestinationInfo(this.destinationName, this.configurationProvider);
    }

    public String getDestinationAccount() {
        return this.destinationAccount;
    }
}

