/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationAuthenticator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationHeader;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.ProxyType;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class HttpDestinationInfoImpl
implements HttpDestinationInfo {
    private static final Map<String, ProxyType> stringToEnumProxyType = new HashMap<String, ProxyType>();
    private static final String HTTPS = "https:";
    private final DestinationConfiguration configuration;
    private final HttpDestinationAuthenticator authenticator;
    private final List<HttpDestinationHeader> headers;
    private final Properties configurationProperties;

    public HttpDestinationInfoImpl(DestinationConfiguration configuration, HttpDestinationAuthenticator authenticator, List<HttpDestinationHeader> headers) {
        this.configuration = configuration;
        this.authenticator = authenticator;
        this.headers = headers;
        this.configurationProperties = new Properties();
        this.configurationProperties.putAll((Map<?, ?>)configuration.getAllProperties());
    }

    @Override
    public HttpDestinationAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public List<HttpDestinationHeader> getHeaders() {
        return this.headers;
    }

    @Override
    public Properties getProperties() {
        return this.configurationProperties;
    }

    @Override
    public String getProperty(String key) {
        return this.configurationProperties.getProperty(key);
    }

    @Override
    public ProxyType getProxyType() {
        String proxyType = this.configurationProperties.getProperty("ProxyType");
        if (proxyType == null || proxyType.isEmpty()) {
            return ProxyType.INTERNET;
        }
        return HttpDestinationInfoImpl.getProxyType(proxyType);
    }

    private static ProxyType getProxyType(String proxyType) {
        if (stringToEnumProxyType.containsKey(proxyType)) {
            return stringToEnumProxyType.get(proxyType);
        }
        throw new IllegalArgumentException(String.format("ProxyType with value %s is not found.", proxyType));
    }

    @Override
    public boolean isSecure() {
        String destinationUrl = this.getDestinationUrl();
        return destinationUrl != null && destinationUrl.startsWith(HTTPS);
    }

    @Override
    public String getDestinationUrl() {
        return this.configurationProperties.getProperty("URL");
    }

    @Override
    public String getName() {
        return this.configurationProperties.getProperty("Name");
    }

    @Override
    public KeyStore getKeyStore() {
        return this.configuration.getKeyStore();
    }

    @Override
    public KeyStore getTrustStore() {
        return this.configuration.getTrustStore();
    }

    static {
        stringToEnumProxyType.put("Internal", ProxyType.INTERNAL);
        stringToEnumProxyType.put("Internet", ProxyType.INTERNET);
        stringToEnumProxyType.put("OnPremise", ProxyType.ON_PREMISE);
    }
}

