/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.destinations.internal.api.ConfigurationProvider;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationAuthenticator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationHeader;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.InvalidDestinationPropertiesException;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationAuthenticatorProvider;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationHeadersProvider;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationInfoImpl;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpDestinationInfoProvider {
    private static final Logger log = Logger.getLogger(HttpDestinationInfoProvider.class.getName());
    private final HttpDestinationAuthenticatorProvider authenticatorProvider;
    private final HttpDestinationHeadersProvider headersProvider;

    public HttpDestinationInfoProvider(HttpDestinationAuthenticatorProvider authenticatorProvider, HttpDestinationHeadersProvider headersProvider) {
        this.authenticatorProvider = authenticatorProvider;
        this.headersProvider = headersProvider;
    }

    public HttpDestinationInfo getHttpDestinationInfo(String name, ConfigurationProvider configurationProvider) throws DestinationNotFoundException {
        DestinationConfiguration configuration = configurationProvider.getDestinationConfiguration(name);
        if (configuration == null) {
            throw new DestinationNotFoundException("Destination with name " + name + " is not found");
        }
        return this.createNewDestinationInfo(configuration);
    }

    private HttpDestinationInfo createNewDestinationInfo(DestinationConfiguration configuration) {
        HttpDestinationAuthenticator authenticator = this.authenticatorProvider.getAuthenticator(configuration);
        List<HttpDestinationHeader> headers = this.headersProvider.getHeaders(configuration);
        HttpDestinationInfoImpl httpDestinationInfo = new HttpDestinationInfoImpl(configuration, authenticator, headers);
        if (authenticator != null) {
            try {
                authenticator.validateDestinationProperties(httpDestinationInfo);
            }
            catch (UnsupportedOperationException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Authenticator for authentication type '" + authenticator.getType() + "' does not support destination properites validation.");
                }
            }
            catch (InvalidDestinationPropertiesException e) {
                throw new IllegalArgumentException("Authenticator for authentication type '" + authenticator.getType() + "' needs valid configuration.\nDetails: " + e.getMessage(), e);
            }
        }
        return httpDestinationInfo;
    }
}

