/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;

public class HttpDestinationSessionCookies {
    private static final Logger log = Logger.getLogger(HttpDestinationSessionCookies.class.getName());
    private static final int COOKIE_EXPIRATION_TOLERANCE = 5000;
    private final Pattern[] sessionCookiePatterns;

    public HttpDestinationSessionCookies(String[] sessionCookieNames) {
        if (sessionCookieNames == null || sessionCookieNames.length == 0) {
            throw new IllegalArgumentException("Session cookie names must not be null or empty");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("Custom defined session cookie names: %s", Arrays.toString(sessionCookieNames)));
        }
        this.sessionCookiePatterns = new Pattern[sessionCookieNames.length];
        for (int i = 0; i < sessionCookieNames.length; ++i) {
            this.sessionCookiePatterns[i] = Pattern.compile(sessionCookieNames[i]);
        }
    }

    public boolean containedIn(CookieStore cookieStore) {
        List cookies;
        List list = cookies = cookieStore == null ? null : cookieStore.getCookies();
        if (cookies == null) {
            return false;
        }
        Date date = this.getDate();
        HashSet<Pattern> matchedPatterns = new HashSet<Pattern>(this.sessionCookiePatterns.length);
        for (Cookie cookie : cookies) {
            if (!cookie.isExpired(date)) {
                matchedPatterns.addAll(this.getMatchedPatterns(cookie));
                if (matchedPatterns.size() != this.sessionCookiePatterns.length) continue;
                return true;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, String.format("Cookie '%s' is expired and not checked", cookie.getName()));
        }
        return false;
    }

    public CookieStore removeFrom(CookieStore cookieStore) {
        BasicCookieStore newCookieStore;
        List cookies = cookieStore == null ? null : cookieStore.getCookies();
        BasicCookieStore basicCookieStore = newCookieStore = cookies == null ? null : new BasicCookieStore();
        if (cookies != null) {
            Date date = this.getDate();
            for (Cookie cookie : cookies) {
                if (!cookie.isExpired(date) && !this.isSessionCookie(cookie)) {
                    newCookieStore.addCookie(cookie);
                    continue;
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, String.format("Cookie '%s' is removed from the cookie store", cookie.getName()));
            }
        }
        return newCookieStore;
    }

    private Date getDate() {
        return new Date(System.currentTimeMillis() + 5000L);
    }

    private boolean isSessionCookie(Cookie cookie) {
        return !this.getMatchedPatterns(cookie).isEmpty();
    }

    private Set<Pattern> getMatchedPatterns(Cookie cookie) {
        String cookieName = cookie.getName();
        HashSet<Pattern> matchedPatterns = new HashSet<Pattern>(this.sessionCookiePatterns.length);
        for (Pattern pattern : this.sessionCookiePatterns) {
            Matcher m = pattern.matcher(cookieName);
            if (!m.matches()) continue;
            matchedPatterns.add(pattern);
        }
        return matchedPatterns;
    }
}

