/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.httpdestination.common.HttpClientBuilderWrapper;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.impl.DestinationClientConnectionManager;
import com.sap.core.connectivity.httpdestination.impl.internals.ConfigurableSchemePortResolver;
import com.sap.core.connectivity.httpdestination.impl.trustmanager.TrustAllManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class HttpsConfigurator {
    private static final Logger log = Logger.getLogger(HttpsConfigurator.class.getName());
    protected static final String TLS = "TLS";
    private static final String HTTP = "http";
    private final HttpDestinationInfo info;
    private KeyStore keyStore;
    private char[] keyStorePassword;
    private TrustManager trustManager;
    private HostnameVerifier hostnameVerifier;

    public HttpsConfigurator(HttpDestinationInfo info) {
        this.info = info;
    }

    TrustManager getTrustManager() {
        return this.trustManager;
    }

    public HttpsConfigurator useTrustStore() {
        if (this.isTrustAll()) {
            this.trustManager = new TrustAllManager();
            this.hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        } else {
            this.trustManager = this.createTrustManager();
            this.hostnameVerifier = this.createHostnameVerifier();
        }
        return this;
    }

    private boolean isTrustAll() {
        return Boolean.parseBoolean(this.getProperty("TrustAll"));
    }

    private TrustManager createTrustManager() {
        try {
            KeyStore trustStore = this.info.getTrustStore();
            return this.createTrustManager(trustStore);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException("Trust manager cannot be created", ex);
        }
    }

    private X509TrustManager createTrustManager(KeyStore truststore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(truststore);
        TrustManager[] trustManagers = tmFactory.getTrustManagers();
        if (trustManagers != null && trustManagers.length > 0) {
            return (X509TrustManager)trustManagers[0];
        }
        return null;
    }

    private HostnameVerifier createHostnameVerifier() {
        String hostnameVerifierProperty = this.getProperty("HostnameVerifier");
        if (this.isNullOrEmpty(hostnameVerifierProperty)) {
            return new DefaultHostnameVerifier();
        }
        if ("BrowserCompatible".equals(hostnameVerifierProperty)) {
            return new DefaultHostnameVerifier();
        }
        if ("Strict".equals(hostnameVerifierProperty)) {
            return new DefaultHostnameVerifier();
        }
        throw new IllegalArgumentException(String.format("Host Name Verifier with value %s is not found.", hostnameVerifierProperty));
    }

    public HttpsConfigurator useKeyStore() {
        this.keyStore = this.info.getKeyStore();
        if (this.keyStore != null) {
            String keyStoreLocation = this.getProperty("KeyStoreLocation");
            String keyStorePass = this.getProperty("KeyStorePassword");
            if (keyStorePass != null) {
                this.keyStorePassword = keyStorePass.toCharArray();
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Loaded key store for destination " + this.info.getName() + " with path " + keyStoreLocation);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Skipped loading of key store for destination " + this.info.getName() + " because there is no key store location or password set");
        }
        return this;
    }

    public void configure(HttpClientBuilderWrapper builder) throws DestinationException {
        try {
            URI destinationUri = new URI(this.info.getDestinationUrl());
            SSLConnectionSocketFactory sslConnectionSocketFactory = this.createSSLConnectionSocketFactory();
            int port = destinationUri.getPort();
            String scheme = destinationUri.getScheme();
            ConfigurableSchemePortResolver portResolver = new ConfigurableSchemePortResolver();
            if (port > 0) {
                portResolver.setPortForScheme(scheme, port);
            }
            Registry registry = RegistryBuilder.create().register(scheme, (Object)sslConnectionSocketFactory).register(HTTP, (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
            DestinationClientConnectionManager connectionManager = new DestinationClientConnectionManager((Registry<ConnectionSocketFactory>)registry, this.info);
            builder.setSchemePortResolver(portResolver);
            builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        catch (Exception e) {
            throw new DestinationException(e.getMessage(), e);
        }
    }

    private SSLConnectionSocketFactory createSSLConnectionSocketFactory() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        KeyManager[] keyManagers = this.createKeyManagers();
        SSLContext ctx = this.getSSLContext();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Using SSL/TLS protocol version: " + ctx.getProtocol());
        }
        ctx.init(keyManagers, new TrustManager[]{this.trustManager}, null);
        boolean useTlsOnly = this.info.getAuthenticator().getType().equals("InternalSystemAuthentication");
        if (useTlsOnly) {
            return new SSLConnectionSocketFactory((SSLSocketFactory)new TlsOnlySSLSocketFactory(ctx.getSocketFactory()), this.hostnameVerifier);
        }
        return new SSLConnectionSocketFactory(ctx, this.hostnameVerifier);
    }

    protected SSLContext getSSLContext() throws NoSuchAlgorithmException {
        String tlsVersion = this.getProperty("TLSVersion");
        if (!this.isNullOrEmpty(tlsVersion)) {
            try {
                return SSLContext.getInstance(tlsVersion);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalArgumentException(String.format("Invalid %s property: %s", "TLSVersion", tlsVersion), ex);
            }
        }
        return SSLContext.getInstance(TLS);
    }

    private KeyManager[] createKeyManagers() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        if (this.keyStore == null) {
            return null;
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.keyStore, this.keyStorePassword);
        return keyManagerFactory.getKeyManagers();
    }

    private String getProperty(String name) {
        return this.info.getProperty(name);
    }

    private boolean isNullOrEmpty(String property) {
        return property == null || property.isEmpty();
    }

    private static class TlsOnlySSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory socketfactory;

        TlsOnlySSLSocketFactory(SSLSocketFactory socketfactory) {
            this.socketfactory = socketfactory;
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.disableSSL(this.socketfactory.createSocket());
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.disableSSL(this.socketfactory.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.disableSSL(this.socketfactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.disableSSL(this.socketfactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.disableSSL(this.socketfactory.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.disableSSL(this.socketfactory.createSocket(address, port, localAddress, localPort));
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.socketfactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.socketfactory.getSupportedCipherSuites();
        }

        private Socket disableSSL(Socket socket) {
            if (!(socket instanceof SSLSocket)) {
                return socket;
            }
            SSLSocket sslSocket = (SSLSocket)socket;
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            for (String protocol : sslSocket.getSupportedProtocols()) {
                if (protocol.startsWith("SSL")) continue;
                enabledProtocols.add(protocol);
            }
            sslSocket.setEnabledProtocols(enabledProtocols.toArray(new String[enabledProtocols.size()]));
            return sslSocket;
        }
    }
}

