/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.apptoappsso;

import com.sap.core.connectivity.httpdestination.impl.HttpClientOperation;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationSessionCookies;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.CookieStore;
import org.apache.http.protocol.HttpContext;

abstract class AppToAppSsoOperation<T>
implements HttpClientOperation<T> {
    private static final Logger log = Logger.getLogger(AppToAppSsoOperation.class.getName());
    private final HttpDestinationSessionCookies httpDestinationSessionCookies;

    AppToAppSsoOperation(HttpDestinationSessionCookies httpDestinationSessionCookies) {
        this.httpDestinationSessionCookies = httpDestinationSessionCookies;
    }

    @Override
    public final T execute(HttpContext context) throws IOException {
        T result = this.executeImpl(context);
        if (this.isSessionExpired(result, context)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session expired, the session cookies will be cleared and the request will be retried");
            }
            if (result instanceof Closeable) {
                ((Closeable)result).close();
            }
            this.removeSessionCookiesFrom(context);
            result = this.executeImpl(context);
        }
        return result;
    }

    protected abstract T executeImpl(HttpContext var1) throws IOException;

    protected abstract boolean isLoginChallengeResult(T var1);

    private boolean isSessionExpired(T result, HttpContext context) {
        return this.isSessionAware(context) && this.isLoginChallengeResult(result);
    }

    private boolean isSessionAware(HttpContext context) {
        return this.httpDestinationSessionCookies != null && this.hasCookieStore(context);
    }

    private boolean hasCookieStore(HttpContext context) {
        return context != null && context.getAttribute("http.cookie-store") != null;
    }

    private void removeSessionCookiesFrom(HttpContext context) {
        CookieStore cookieStore = (CookieStore)context.getAttribute("http.cookie-store");
        CookieStore newCookieStore = this.httpDestinationSessionCookies.removeFrom(cookieStore);
        context.setAttribute("http.cookie-store", (Object)newCookieStore);
    }
}

