/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.apptoappsso;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

class AppToAppSsoResponseHandler<T>
implements ResponseHandler<T> {
    private static final Logger log = Logger.getLogger(AppToAppSsoResponseHandler.class.getName());
    private static final String SECURITY_LOGIN_CHALLENGE_HEADER = "com.sap.cloud.security.login";
    private static final String SECURITY_LOGIN_CHALLENGE_VALUE = "login-request";
    private ResponseHandler<T> responseHandler;
    private boolean isLoginChallenged;

    public AppToAppSsoResponseHandler(ResponseHandler<T> responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("Response handler must not be null");
        }
        this.responseHandler = responseHandler;
    }

    public T handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        this.isLoginChallenged = AppToAppSsoResponseHandler.isLoginChallengeResponse(httpResponse);
        return (T)this.responseHandler.handleResponse(httpResponse);
    }

    public static boolean isLoginChallengeResponse(HttpResponse httpResponse) {
        boolean isLoginChallengeResponse;
        Header header = httpResponse.getFirstHeader(SECURITY_LOGIN_CHALLENGE_HEADER);
        boolean bl = isLoginChallengeResponse = header != null && SECURITY_LOGIN_CHALLENGE_VALUE.equals(header.getValue());
        if (log.isLoggable(Level.FINE) && isLoginChallengeResponse) {
            log.log(Level.FINE, "A login challenge response is recognized");
        }
        return isLoginChallengeResponse;
    }

    public boolean isLoginChallenged() {
        return this.isLoginChallenged;
    }
}

