/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.auth;

import com.sap.core.connectivity.httpdestination.common.HttpDestinationContext;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.InvalidDestinationPropertiesException;
import com.sap.core.connectivity.httpdestination.impl.auth.AbstractAuthenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;

public class BasicAuthenticator
extends AbstractAuthenticator {
    private final Logger log = Logger.getLogger(BasicAuthenticator.class.getName());

    @Override
    public String getType() {
        return "BasicAuthentication";
    }

    @Override
    public void authenticate(HttpDestinationContext context) throws SecurityException {
        this.prepareContext(context);
        HttpDestinationInfo info = context.getHttpDestinationInfo();
        if (this.isPreemptive(info)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "Enabling preemptive authentication");
            }
            URL url = this.getUrl(info);
            this.authenticatePreemptiveAuth(context, url);
        }
    }

    private void prepareContext(HttpDestinationContext context) {
        CredentialsProvider credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        if (credentialsProvider == null) {
            final CredentialsProvider defaultCredentialsProvider = context.getDefaultCredentialsProvider();
            context.setAttribute("http.auth.credentials-provider", new BasicCredentialsProvider(){

                public void setCredentials(AuthScope authscope, Credentials credentials) {
                    if (BasicAuthenticator.this.log.isLoggable(Level.FINE)) {
                        BasicAuthenticator.this.log.log(Level.FINE, "The creadentials provider is read only, so ignore the operation");
                    }
                }

                public Credentials getCredentials(AuthScope authscope) {
                    return defaultCredentialsProvider.getCredentials(authscope);
                }

                public String toString() {
                    return defaultCredentialsProvider.toString();
                }
            });
        }
    }

    private void authenticatePreemptiveAuth(HttpContext context, URL url) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(new HttpHost(url.getHost(), url.getPort(), url.getProtocol()), (AuthScheme)basicAuth);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
    }

    private boolean isPreemptive(HttpDestinationInfo info) {
        String preemptive = info.getProperty("Preemptive");
        if (preemptive == null || preemptive.isEmpty()) {
            return true;
        }
        if (Boolean.FALSE.toString().equals(preemptive)) {
            return false;
        }
        if (Boolean.TRUE.toString().equals(preemptive)) {
            return true;
        }
        throw new IllegalArgumentException("Unsupported value for the preemptive property, it should only be true or false");
    }

    @Override
    public void validateDestinationProperties(HttpDestinationInfo destinationInfo) throws UnsupportedOperationException, InvalidDestinationPropertiesException {
        Properties properties = destinationInfo.getProperties();
        if (this.isValueEmpty(properties, "User") || this.isValueEmpty(properties, "Password")) {
            throw new InvalidDestinationPropertiesException("Authentication is BASIC, but no user and password supplied");
        }
    }

    @Override
    protected void populateAcceptedAttributeNames(Collection<String> acceptedAttributeNames) {
        acceptedAttributeNames.add("User");
        acceptedAttributeNames.add("Password");
        acceptedAttributeNames.add("TrustStoreLocation");
        acceptedAttributeNames.add("TrustStorePassword");
        acceptedAttributeNames.add("TrustAll");
        acceptedAttributeNames.add("Preemptive");
        acceptedAttributeNames.add("HostnameVerifier");
    }

    @Override
    protected void populateRequiredAttributeNames(Collection<String> requiredAttributeNames) {
        requiredAttributeNames.add("User");
        requiredAttributeNames.add("Password");
    }

    private URL getUrl(HttpDestinationInfo info) {
        try {
            return new URL(info.getDestinationUrl());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed destination URL", e);
        }
    }

    private boolean isValueEmpty(Properties destinationProperties, String key) {
        if (!destinationProperties.containsKey(key)) {
            return true;
        }
        String value = destinationProperties.getProperty(key);
        return value == null || value.isEmpty();
    }
}

