/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.auth;

import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.InvalidDestinationPropertiesException;
import com.sap.core.connectivity.httpdestination.impl.auth.AbstractAuthenticator;
import java.util.Collection;
import java.util.Properties;

public class ClientCertAuthenticator
extends AbstractAuthenticator {
    @Override
    public String getType() {
        return "ClientCertificateAuthentication";
    }

    @Override
    public void validateDestinationProperties(HttpDestinationInfo destinationInfo) throws InvalidDestinationPropertiesException {
        StringBuilder sb = new StringBuilder();
        boolean successfulValidation = true;
        Properties properties = destinationInfo.getProperties();
        if (this.isValueEmpty(properties, "KeyStoreLocation")) {
            sb.append("Key store is not supplied\n");
            successfulValidation = false;
        }
        if (!successfulValidation) {
            throw new InvalidDestinationPropertiesException(sb.toString());
        }
    }

    private boolean isValueEmpty(Properties destinationProperties, String key) {
        if (!destinationProperties.containsKey(key)) {
            return true;
        }
        String value = destinationProperties.getProperty(key);
        return value == null || value.isEmpty();
    }

    @Override
    protected void populateAcceptedAttributeNames(Collection<String> acceptedAttributeNames) {
        acceptedAttributeNames.add("TrustStorePassword");
        acceptedAttributeNames.add("KeyStorePassword");
        acceptedAttributeNames.add("TrustStoreLocation");
        acceptedAttributeNames.add("KeyStoreLocation");
        acceptedAttributeNames.add("TrustAll");
        acceptedAttributeNames.add("HostnameVerifier");
    }

    @Override
    protected void populateRequiredAttributeNames(Collection<String> requiredAttributeNames) {
        requiredAttributeNames.add("KeyStorePassword");
        requiredAttributeNames.add("KeyStoreLocation");
    }
}

