/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.auth;

import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.InvalidDestinationPropertiesException;
import com.sap.core.connectivity.httpdestination.impl.auth.AbstractAuthenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;

public class OAuth2ClientCredentialsAuthenticator
extends AbstractAuthenticator {
    @Override
    public String getType() {
        return "OAuth2ClientCredentials";
    }

    @Override
    protected void populateAcceptedAttributeNames(Collection<String> acceptedAttributeNames) {
        acceptedAttributeNames.add("tokenServiceURL");
        acceptedAttributeNames.add("tokenServiceUser");
        acceptedAttributeNames.add("tokenServicePassword");
        acceptedAttributeNames.add("clientSecret");
        acceptedAttributeNames.add("clientId");
        acceptedAttributeNames.add("scope");
    }

    @Override
    protected void populateRequiredAttributeNames(Collection<String> requiredAttributeNames) {
        requiredAttributeNames.add("tokenServiceURL");
        requiredAttributeNames.add("clientId");
    }

    @Override
    public void validateDestinationProperties(HttpDestinationInfo destinationInfo) throws InvalidDestinationPropertiesException {
        Properties properties = destinationInfo.getProperties();
        this.checkRequiredAttributeNames(properties);
        this.checkTokenURL(properties.getProperty("tokenServiceURL"));
    }

    private void checkRequiredAttributeNames(Properties destinationProperties) throws InvalidDestinationPropertiesException {
        for (String property : this.getRequiredAttributeNames()) {
            String value = destinationProperties.getProperty(property);
            if (value != null && !value.isEmpty()) continue;
            throw new InvalidDestinationPropertiesException("Required destination attribute '" + property + "' is not defined.");
        }
    }

    private void checkTokenURL(String tokenServiceURL) throws InvalidDestinationPropertiesException {
        try {
            new URL(tokenServiceURL);
        }
        catch (MalformedURLException e) {
            throw new InvalidDestinationPropertiesException("Required destination attribute 'tokenServiceURL' value '" + tokenServiceURL + "' is not valid.", e);
        }
    }
}

