/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.auth;

import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.InvalidDestinationPropertiesException;
import com.sap.core.connectivity.httpdestination.impl.auth.AbstractAuthenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;

public class OAuth2SAMLBearerAssertionAuthenticator
extends AbstractAuthenticator {
    public static final String AUDIENCE = "audience";
    public static final String CLIENT_KEY = "clientKey";
    public static final String TOKEN_SERVICE_URL = "tokenServiceURL";
    public static final String TOKEN_SERVICE_USER = "tokenServiceUser";
    public static final String TOKEN_SERVICE_PASSWORD = "tokenServicePassword";
    public static final String SYSTEM_USER = "SystemUser";
    public static final String NAME_QUALIFIER = "nameQualifier";
    public static final String COMPANY_ID = "companyId";
    public static final String ASSERTION_ISSUER = "assertionIssuer";
    public static final String SCOPE = "scope";
    public static final String AUTHN_CONTEXT_CLASS_REF = "authnContextClassRef";
    public static final String NAME_ID_FORMAT = "nameIdFormat";
    public static final String USER_ID_SOURCE = "userIdSource";

    @Override
    public String getType() {
        return "OAuth2SAMLBearerAssertion";
    }

    @Override
    protected void populateAcceptedAttributeNames(Collection<String> acceptedAttributeNames) {
        acceptedAttributeNames.add(TOKEN_SERVICE_URL);
        acceptedAttributeNames.add(TOKEN_SERVICE_USER);
        acceptedAttributeNames.add(TOKEN_SERVICE_PASSWORD);
        acceptedAttributeNames.add(CLIENT_KEY);
        acceptedAttributeNames.add(AUDIENCE);
        acceptedAttributeNames.add(SYSTEM_USER);
        acceptedAttributeNames.add(NAME_QUALIFIER);
        acceptedAttributeNames.add(COMPANY_ID);
        acceptedAttributeNames.add(ASSERTION_ISSUER);
        acceptedAttributeNames.add(SCOPE);
    }

    @Override
    protected void populateRequiredAttributeNames(Collection<String> requiredAttributeNames) {
        requiredAttributeNames.add(TOKEN_SERVICE_URL);
        requiredAttributeNames.add(CLIENT_KEY);
        requiredAttributeNames.add(AUDIENCE);
    }

    @Override
    public void validateDestinationProperties(HttpDestinationInfo destinationInfo) throws InvalidDestinationPropertiesException {
        Properties properties = destinationInfo.getProperties();
        this.checkRequiredAttributeNames(properties);
        this.checkTokenURL(properties.getProperty(TOKEN_SERVICE_URL));
    }

    private void checkRequiredAttributeNames(Properties destinationProperties) throws InvalidDestinationPropertiesException {
        for (String property : this.getRequiredAttributeNames()) {
            String value = destinationProperties.getProperty(property);
            if (value != null && !value.isEmpty()) continue;
            throw new InvalidDestinationPropertiesException("Required destination attribute '" + property + "' is not defined.");
        }
    }

    private void checkTokenURL(String tokenServiceURL) throws InvalidDestinationPropertiesException {
        try {
            new URL(tokenServiceURL);
        }
        catch (MalformedURLException e) {
            throw new InvalidDestinationPropertiesException("Required destination attribute 'tokenServiceURL' value '" + tokenServiceURL + "' is not valid.", e);
        }
    }
}

