/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.configurator;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.httpdestination.common.HttpClientBuilderWrapper;
import com.sap.core.connectivity.httpdestination.common.HttpClientConfigurator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationAuthenticator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.impl.configurator.BasicAuthenticatorConfigurator;
import com.sap.core.connectivity.httpdestination.impl.configurator.ClientCertAuthenticatorConfigurator;
import com.sap.core.connectivity.httpdestination.impl.configurator.DefaultAuthenticatorConfigurator;
import com.sap.core.connectivity.httpdestination.impl.configurator.PrincipalPropagationAuthenticatorConfigurator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.CredentialsProvider;

public final class AuthenticatorConfigurator
implements HttpClientConfigurator {
    private static final Logger logger = Logger.getLogger(AuthenticatorConfigurator.class.getName());
    private final Map<String, HttpClientConfigurator> authenticatorConfigurators;

    public AuthenticatorConfigurator(CredentialsProvider credentialsProvider) {
        Map<String, HttpClientConfigurator> configurators = this.initAuthConfigurators(credentialsProvider);
        this.authenticatorConfigurators = Collections.unmodifiableMap(configurators);
    }

    private Map<String, HttpClientConfigurator> initAuthConfigurators(CredentialsProvider credentialsProvider) {
        HashMap<String, HttpClientConfigurator> configurators = new HashMap<String, HttpClientConfigurator>();
        DefaultAuthenticatorConfigurator defaultAuthenticatorConfigurator = new DefaultAuthenticatorConfigurator();
        configurators.put("AppToAppSSO", defaultAuthenticatorConfigurator);
        configurators.put("NoAuthentication", defaultAuthenticatorConfigurator);
        configurators.put("SAPAssertionSSO", defaultAuthenticatorConfigurator);
        configurators.put("OAuth2ClientCredentials", defaultAuthenticatorConfigurator);
        configurators.put("OAuth2SAMLBearerAssertion", defaultAuthenticatorConfigurator);
        BasicAuthenticatorConfigurator basicAuthenticatorConfigurator = new BasicAuthenticatorConfigurator(credentialsProvider);
        configurators.put("BasicAuthentication", basicAuthenticatorConfigurator);
        ClientCertAuthenticatorConfigurator clientCertAuthenticatorConfigurator = new ClientCertAuthenticatorConfigurator();
        configurators.put("ClientCertificateAuthentication", clientCertAuthenticatorConfigurator);
        configurators.put("InternalSystemAuthentication", clientCertAuthenticatorConfigurator);
        PrincipalPropagationAuthenticatorConfigurator principalPropagationAuthenticatorConfigurator = new PrincipalPropagationAuthenticatorConfigurator();
        configurators.put("PrincipalPropagation", principalPropagationAuthenticatorConfigurator);
        return configurators;
    }

    @Override
    public void configure(HttpClientBuilderWrapper builder, HttpDestinationInfo destinationInfo) throws DestinationException {
        HttpDestinationAuthenticator authenticator = destinationInfo.getAuthenticator();
        if (authenticator == null) {
            throw new DestinationException(String.format("There is no registered authenticator for authentication type '%s'", destinationInfo.getProperty("Authentication")));
        }
        HttpClientConfigurator authenticatorConfigurator = this.authenticatorConfigurators.get(authenticator.getType());
        if (authenticatorConfigurator == null) {
            throw new DestinationException("Unsupported authenticator type: " + authenticator.getType());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.format("Will use authenticator type '%s' with configurator '%s'", authenticator.getType(), authenticatorConfigurator.getClass().getName()));
        }
        authenticatorConfigurator.configure(builder, destinationInfo);
    }
}

