/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.configurator;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.httpdestination.common.HttpClientBuilderWrapper;
import com.sap.core.connectivity.httpdestination.common.HttpClientConfigurator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.impl.HttpsConfigurator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;

final class BasicAuthenticatorConfigurator
implements HttpClientConfigurator {
    private static final Logger logger = Logger.getLogger(BasicAuthenticatorConfigurator.class.getName());
    private CredentialsProvider credentialsProvider;

    public BasicAuthenticatorConfigurator(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public void configure(HttpClientBuilderWrapper builder, HttpDestinationInfo destinationInfo) throws DestinationException {
        if (destinationInfo.isSecure()) {
            HttpsConfigurator configurator = new HttpsConfigurator(destinationInfo);
            configurator.useTrustStore();
            configurator.configure(builder);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.format("Configuring basic authentication for destination with name %s", destinationInfo.getName()));
        }
        AuthScope authscope = this.getScope(destinationInfo);
        Credentials credentials = this.getCredentials(destinationInfo);
        if (null == credentials) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("There are no credentials set for AuthScope [%s:%d]. Skipping credentials config.", authscope.getHost(), authscope.getPort()));
            }
            return;
        }
        this.credentialsProvider.setCredentials(authscope, credentials);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.format("Configured credentials for auth scope [%s] and destination with name [%s]", authscope.toString(), destinationInfo.getName()));
        }
    }

    private AuthScope getScope(HttpDestinationInfo info) throws DestinationException {
        URL url = this.getUrl(info);
        return new AuthScope(url.getHost(), url.getPort());
    }

    private URL getUrl(HttpDestinationInfo info) throws DestinationException {
        try {
            return new URL(info.getDestinationUrl());
        }
        catch (MalformedURLException e) {
            throw new DestinationException("Malformed destination URL", e);
        }
    }

    private Credentials getCredentials(HttpDestinationInfo info) {
        String username = info.getProperty("User");
        String password = info.getProperty("Password");
        if (username != null && password != null) {
            return new UsernamePasswordCredentials(username, password);
        }
        return null;
    }
}

