/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.configurator;

import com.sap.core.connectivity.httpdestination.common.HttpClientBuilderWrapper;
import com.sap.core.connectivity.httpdestination.common.HttpClientConfigurator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.ProxyType;
import java.net.ProxySelector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;

public class ProxyConfigurator
implements HttpClientConfigurator {
    private static final Logger logger = Logger.getLogger(ProxyConfigurator.class.getName());
    private CredentialsProvider credentialsProvider = null;

    public ProxyConfigurator(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public void configure(HttpClientBuilderWrapper builder, HttpDestinationInfo destinationInfo) {
        String authType = destinationInfo.getProperty("Authentication");
        if ("InternalSystemAuthentication".equals(authType)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "S2S proxy configuration will be performed " + authType);
            }
            this.configureProxyForSystemDestination(builder, destinationInfo);
            return;
        }
        this.checkForProxyProperty(destinationInfo);
        ProxyType proxyType = destinationInfo.getProxyType();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Proxy type being used is %s", (Object)proxyType);
        }
        switch (proxyType) {
            case ON_PREMISE: {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.log(Level.FINE, "No proxy is going to be configured for on-premise destination.");
                break;
            }
            case INTERNET: {
                this.configureProxyForInternetDestination(builder, destinationInfo);
                break;
            }
            case INTERNAL: {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.log(Level.FINE, "No proxy is going to be configured since the destination is internal.");
            }
        }
    }

    private void configureProxyForSystemDestination(HttpClientBuilderWrapper builder, HttpDestinationInfo httpDestinationInfo) {
        String proxyUrl = httpDestinationInfo.getProperty("SystemProxy");
        String proxyUser = httpDestinationInfo.getProperty("SystemProxyUser");
        String proxyPass = httpDestinationInfo.getProperty("SystemProxyPassword");
        if (proxyUrl == null || proxyUrl.isEmpty()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No system proxy is configured.");
            }
            return;
        }
        String[] hostPort = proxyUrl.split(":");
        if (hostPort.length != 2) {
            logger.log(Level.SEVERE, String.format("Ignore invalid system proxy value: %s, no system proxy is configured.", proxyUrl));
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Will configure system proxy:");
            logger.log(Level.FINE, "System proxy: " + proxyUrl);
            logger.log(Level.FINE, "System proxy user: " + proxyUser);
        }
        String proxyHost = hostPort[0];
        String proxyPortStr = hostPort[1];
        try {
            int proxyPort = Integer.parseInt(proxyPortStr);
            if (proxyUser != null) {
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(proxyUser, proxyPass);
                this.credentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            builder.setProxy(proxy);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "System Proxy is configured.");
            }
        }
        catch (NumberFormatException ex) {
            logger.log(Level.SEVERE, String.format("Ignore invalid system proxy value: %s, no system proxy is configured.", proxyUrl));
        }
    }

    private void configureProxyForInternetDestination(HttpClientBuilderWrapper builder, HttpDestinationInfo destinationInfo) {
        ProxySelector proxySelector = ProxySelector.getDefault();
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(proxySelector);
        builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Configured internet proxy to use ProxySelector");
        }
    }

    private void checkForProxyProperty(HttpDestinationInfo httpDestinationInfo) {
        String proxyPassword;
        String proxyUser;
        String warningMessage = "Property %s is not supported any longer. Instead, proxy can be configured by specifying property ProxyType. Possible values are Internet, OnPremise and Internal. See documentation for more details.";
        String proxy = httpDestinationInfo.getProperty("Proxy");
        if (proxy != null && !proxy.isEmpty() && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, String.format(warningMessage, "Proxy"));
        }
        if ((proxyUser = httpDestinationInfo.getProperty("ProxyUser")) != null && !proxyUser.isEmpty() && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, String.format(warningMessage, "ProxyUser"));
        }
        if ((proxyPassword = httpDestinationInfo.getProperty("ProxyPassword")) != null && !proxyPassword.isEmpty() && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, String.format(warningMessage, "ProxyPassword"));
        }
    }
}

