/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.configurator;

import com.sap.core.connectivity.httpdestination.common.HttpClientBuilderWrapper;
import com.sap.core.connectivity.httpdestination.common.HttpClientConfigurator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import org.apache.http.client.config.RequestConfig;

public class RequestConfigurator
implements HttpClientConfigurator {
    private final boolean configureTimeouts;

    public RequestConfigurator(boolean configureTimeouts) {
        this.configureTimeouts = configureTimeouts;
    }

    @Override
    public void configure(HttpClientBuilderWrapper builder, HttpDestinationInfo destinationInfo) {
        String allowRedirectValue;
        RequestConfig.Builder defaultRequestConfiguration = RequestConfig.custom();
        defaultRequestConfiguration.setNormalizeUri(false);
        if (this.configureTimeouts) {
            String readTimeout;
            String connectionTimeout = destinationInfo.getProperty("URL.connectionTimeoutInSeconds");
            if (connectionTimeout != null) {
                defaultRequestConfiguration.setConnectTimeout(Integer.parseInt(connectionTimeout) * 1000);
            }
            if ((readTimeout = destinationInfo.getProperty("URL.socketReadTimeoutInSeconds")) != null) {
                defaultRequestConfiguration.setSocketTimeout(Integer.parseInt(readTimeout) * 1000);
            }
        }
        if ((allowRedirectValue = destinationInfo.getProperty("URL.followRedirects")) == null || allowRedirectValue.isEmpty()) {
            allowRedirectValue = "true";
        }
        defaultRequestConfiguration.setRedirectsEnabled(Boolean.parseBoolean(allowRedirectValue));
        builder.setDefaultRequestConfig(defaultRequestConfiguration.build());
    }
}

