/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.configurator;

import com.sap.core.connectivity.httpdestination.common.HttpClientBuilderWrapper;
import com.sap.core.connectivity.httpdestination.common.HttpClientConfigurator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.http.message.BasicHeader;

public final class URLHeaderConfigurator
implements HttpClientConfigurator {
    @Override
    public void configure(HttpClientBuilderWrapper builder, HttpDestinationInfo destinationInfo) {
        List<BasicHeader> extractedHeaders = this.extractHeaders(destinationInfo);
        builder.setDefaultHeaders(extractedHeaders);
    }

    public List<BasicHeader> extractHeaders(HttpDestinationInfo destinationInfo) {
        int prefixLength = "URL.headers.".length();
        Properties destinationProperties = destinationInfo.getProperties();
        Set<String> propertyNames = destinationProperties.stringPropertyNames();
        ArrayList<BasicHeader> extractedHeaders = new ArrayList<BasicHeader>();
        for (String propertyName : propertyNames) {
            if (!propertyName.startsWith("URL.headers.")) continue;
            String headerNameWithoutPrefix = propertyName.substring(prefixLength);
            extractedHeaders.add(new BasicHeader(headerNameWithoutPrefix, destinationProperties.getProperty(propertyName)));
        }
        return extractedHeaders;
    }
}

