/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.header;

import com.sap.core.connectivity.api.authentication.AuthenticationHeader;
import com.sap.core.connectivity.httpdestination.common.HttpConnectionInfo;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationHeader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractAuthenticationHeader
implements HttpDestinationHeader {
    private static final Logger log = Logger.getLogger(AbstractAuthenticationHeader.class.getName());
    private final AuthenticationHeaderRetriever authenticationHeaderRetriever;

    protected AbstractAuthenticationHeader(AuthenticationHeaderRetriever authenticationHeaderRetriever) {
        this.authenticationHeaderRetriever = authenticationHeaderRetriever;
    }

    @Override
    public void inject(HttpConnectionInfo connectionInfo, HttpRequest request, HttpContext context) {
        String requestUrl = request.getRequestLine().getUri();
        List<AuthenticationHeader> authenticationHeaders = this.authenticationHeaderRetriever.retrieveAuthenticationHeaders(requestUrl);
        if (authenticationHeaders != null) {
            for (AuthenticationHeader authenticationHeader : authenticationHeaders) {
                request.addHeader(authenticationHeader.getName(), authenticationHeader.getValue());
            }
        }
    }

    protected void removeHeaders(HttpRequest request, String headerName, String headerValuePrefix) {
        Header[] headers = request.getHeaders(headerName);
        if (headers != null && headers.length != 0) {
            for (Header header : headers) {
                if (!header.getValue().startsWith(headerValuePrefix)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Header with name " + headerName + " and value " + header.getValue() + " has been removed.");
                }
                request.removeHeader(header);
            }
        }
    }

    protected static interface AuthenticationHeaderRetriever {
        public List<AuthenticationHeader> retrieveAuthenticationHeaders(String var1);
    }
}

