/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.header;

import com.sap.core.connectivity.httpdestination.common.HttpConnectionInfo;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationHeader;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class InternalSystemAuthenticationCertificateHeader
implements HttpDestinationHeader {
    private static final Logger log = Logger.getLogger(InternalSystemAuthenticationCertificateHeader.class.getName());
    private static final String SSL_CLIENT_CERT_HEADER = "SSL_CLIENT_CERT";
    private static final String VM_CERT_ALIAS = "vm_cert";
    private final boolean sslClientCertHeaderNeeded;
    private final String certText;

    public InternalSystemAuthenticationCertificateHeader(HttpDestinationInfo info, boolean sslClientCertHeaderNeeded) {
        this.sslClientCertHeaderNeeded = sslClientCertHeaderNeeded;
        this.certText = this.extractCertificate(info);
    }

    private String extractCertificate(HttpDestinationInfo info) {
        try {
            return DatatypeConverter.printBase64Binary((byte[])info.getKeyStore().getCertificate(VM_CERT_ALIAS).getEncoded());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't load vm_cert: " + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void inject(HttpConnectionInfo connectionInfo, HttpRequest request, HttpContext context) {
        if (this.sslClientCertHeaderNeeded && this.certText != null) {
            request.addHeader(SSL_CLIENT_CERT_HEADER, this.certText);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Add header: SSL_CLIENT_CERT: " + this.certText);
            }
        }
    }
}

