/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.header;

import com.sap.core.connectivity.httpdestination.common.HttpConnectionInfo;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationHeader;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class InternalSystemAuthenticationUserIdHeader
implements HttpDestinationHeader {
    private static final String CLIENT_USER_HEADER = "CLIENT_USER";

    @Override
    public void inject(HttpConnectionInfo connectionInfo, HttpRequest request, HttpContext context) {
        String userId = null;
        try {
            User currentUser;
            UserProvider userProvider = UserManagementAccessor.getUserProvider();
            if (userProvider != null && (currentUser = userProvider.getCurrentUser()) != null) {
                userId = currentUser.getName();
            }
        }
        catch (PersistenceException e) {
            throw new IllegalStateException("Setting the user header for Internal System Authentication failed:", e);
        }
        if (userId != null) {
            request.addHeader(CLIENT_USER_HEADER, userId);
        }
    }
}

