/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.header;

import com.sap.core.connectivity.api.authentication.AuthenticationHeader;
import com.sap.core.connectivity.api.authentication.AuthenticationHeaderProvider;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.httpdestination.common.HttpConnectionInfo;
import com.sap.core.connectivity.httpdestination.impl.header.AbstractAuthenticationHeader;
import com.sap.core.connectivity.httpdestination.impl.header.SessionAwareHeader;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class SAPAssertionHeader
extends AbstractAuthenticationHeader
implements SessionAwareHeader {
    public static final String ASSERTION_HEADER_KEY = "Cookie";
    public static final String ASSERTION_HEADER_PREFIX = "MYSAPSSO2=";

    public SAPAssertionHeader(final AuthenticationHeaderProvider authenticationHeaderProvider, final DestinationConfiguration configuration) {
        super(new AbstractAuthenticationHeader.AuthenticationHeaderRetriever(){

            @Override
            public List<AuthenticationHeader> retrieveAuthenticationHeaders(String requestUrl) {
                return Collections.singletonList(authenticationHeaderProvider.getSAPAssertionHeader(configuration));
            }
        });
    }

    @Override
    public void inject(HttpConnectionInfo connectionInfo, HttpRequest request, HttpContext context) {
        this.removeHeaders(request, ASSERTION_HEADER_KEY, ASSERTION_HEADER_PREFIX);
        super.inject(connectionInfo, request, context);
    }
}

