/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.header;

import com.sap.core.connectivity.api.sappassport.ConnectionInfo;
import com.sap.core.connectivity.api.sappassport.SapPassportHeader;
import com.sap.core.connectivity.api.sappassport.SapPassportHeaderProvider;
import com.sap.core.connectivity.httpdestination.common.HttpConnectionInfo;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationHeader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class SAPPassportHeader
implements HttpDestinationHeader {
    private static final Logger log = Logger.getLogger(SAPPassportHeader.class.getName());
    private final SapPassportHeaderProvider sapPassportHeaderProvider;

    public SAPPassportHeader(SapPassportHeaderProvider sapPassportHeaderProvider) {
        this.sapPassportHeaderProvider = sapPassportHeaderProvider;
    }

    @Override
    public void inject(HttpConnectionInfo connectionInfo, HttpRequest request, HttpContext context) {
        SapPassportHeader sapPassportHeader = this.sapPassportHeaderProvider.getSapPassportHeader((ConnectionInfo)connectionInfo);
        if (sapPassportHeader != null) {
            String sapPassportHeaderName = sapPassportHeader.getName();
            String sapPassportHeaderValue = sapPassportHeader.getValue();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "SAP Passport was generated and will be attached to the HTTP request: " + sapPassportHeaderValue);
            }
            request.removeHeaders(sapPassportHeaderName);
            request.addHeader(sapPassportHeaderName, sapPassportHeaderValue);
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "No SAP-PASSPORT was available from statistics API. It will be not transferred with HTTP request");
        }
    }
}

