/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.header;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.httpdestination.common.HttpConnectionInfo;
import com.sap.core.connectivity.httpdestination.impl.header.AbstractAuthenticationHeader;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UserProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class SkipSSOTokenGenerationWhenNoUserHeader
extends AbstractAuthenticationHeader {
    private static final Logger log = Logger.getLogger(SkipSSOTokenGenerationWhenNoUserHeader.class.getName());
    private static final String SKIP_SSO_TOKEN_GENERATION_NO_USER_PROPERTY = "SkipSSOTokenGenerationWhenNoUser";
    private String headerKey;
    private String headerPrefix;
    private DestinationConfiguration configuration;
    private UserProvider userProvider;

    protected SkipSSOTokenGenerationWhenNoUserHeader(AbstractAuthenticationHeader.AuthenticationHeaderRetriever authenticationHeaderRetriever, DestinationConfiguration configuration, String headerKey, String headerPrefix) {
        super(authenticationHeaderRetriever);
        this.configuration = configuration;
        this.headerKey = headerKey;
        this.headerPrefix = headerPrefix;
    }

    @Override
    public void inject(HttpConnectionInfo connectionInfo, HttpRequest request, HttpContext context) {
        this.removeHeaders(request, this.headerKey, this.headerPrefix);
        if (this.shouldGenerateHeader()) {
            super.inject(connectionInfo, request, context);
        } else {
            log.log(Level.WARNING, "SSO token was not generated because there is no user context into calling thread");
        }
    }

    private boolean shouldGenerateHeader() {
        if (this.configuration.getProperty(SKIP_SSO_TOKEN_GENERATION_NO_USER_PROPERTY) != null) {
            try {
                if (this.userProvider == null) {
                    this.userProvider = UserManagementAccessor.getUserProvider();
                }
                return this.userProvider != null && this.userProvider.getCurrentUser() != null;
            }
            catch (PersistenceException e) {
                throw new IllegalStateException("" + e.toString());
            }
        }
        return true;
    }
}

