/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.interceptor;

import com.sap.core.connectivity.httpdestination.common.RuntimeUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;

public class InterceptorsAccessor {
    private static final RuntimeUtil RUNTIME_UTIL = new RuntimeUtil();
    private static List<HttpRequestInterceptor> httpRequestInterceptors = new ArrayList<HttpRequestInterceptor>();
    private static List<HttpResponseInterceptor> httpResponseInterceptors = new ArrayList<HttpResponseInterceptor>();

    public void addHttpRequestInterceptor(HttpRequestInterceptor requestInterceptor) {
        httpRequestInterceptors.add(requestInterceptor);
    }

    public void addHttpResponseInterceptor(HttpResponseInterceptor responseInterceptor) {
        httpResponseInterceptors.add(responseInterceptor);
    }

    public static List<HttpRequestInterceptor> getHttpRequestInterceptors() {
        if (httpRequestInterceptors.isEmpty() && !RUNTIME_UTIL.isOsgiRuntime()) {
            httpRequestInterceptors = RUNTIME_UTIL.loadJavaServices(HttpRequestInterceptor.class);
        }
        return httpRequestInterceptors;
    }

    public static List<HttpResponseInterceptor> getHttpResponseInterceptors() {
        if (httpResponseInterceptors.isEmpty() && !RUNTIME_UTIL.isOsgiRuntime()) {
            httpResponseInterceptors = RUNTIME_UTIL.loadJavaServices(HttpResponseInterceptor.class);
        }
        return httpResponseInterceptors;
    }
}

