/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.internals;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.UnsupportedSchemeException;

public class ConfigurableSchemePortResolver
implements SchemePortResolver {
    private static final Logger logger = Logger.getLogger(ConfigurableSchemePortResolver.class.getName());
    public static final String SCHEME_HTTPS = "https";
    public static final String SCHEME_HTTP = "http";
    private final Map<String, Integer> schemePorts = new HashMap<String, Integer>();

    public ConfigurableSchemePortResolver() {
        this.schemePorts.put(SCHEME_HTTPS, 443);
        this.schemePorts.put(SCHEME_HTTP, 80);
    }

    public int resolve(HttpHost host) throws UnsupportedSchemeException {
        int defaultPort = host.getPort();
        if (defaultPort != -1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("Using port from HttpHost [%d] for URI [%s]", defaultPort, host.toURI()));
            }
            return defaultPort;
        }
        String scheme = host.getSchemeName();
        if (null == scheme) {
            throw new UnsupportedSchemeException("The scheme cannot be null: " + host.toURI());
        }
        Integer port = this.schemePorts.get(scheme.toLowerCase(Locale.ENGLISH));
        if (null == port) {
            throw new UnsupportedSchemeException(String.format("Cannot determine port for scheme with name [%s]", scheme));
        }
        return port;
    }

    public void setPortForScheme(String scheme, int port) {
        if (null == scheme) {
            throw new IllegalArgumentException("The scheme cannot be null!");
        }
        String sch = scheme.trim().toLowerCase(Locale.ENGLISH);
        if (sch.isEmpty()) {
            throw new IllegalArgumentException("The scheme cannot be empty!");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("The port number is out of range: " + port);
        }
        this.schemePorts.put(sch, port);
    }
}

