/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.jdsr;

import com.sap.core.connectivity.httpdestination.common.HttpConnectionInfo;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.impl.utils.HttpDestinationInfoUtils;
import com.sap.js.statistics.api.writer.DSRExternalRecord;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdsrStatistics {
    private static final Logger log = Logger.getLogger(JdsrStatistics.class.getName());
    private static final String HC_PROCESS_ID = "HC_PROCESS_ID";
    private static final String HC_APPLICATION = "HC_APPLICATION";
    private static final String HC_ACCOUNT = "HC_ACCOUNT";
    private static final String thisSystemId;
    private boolean shouldCollectData = false;
    private Set<DSRExternalRecord> externalRecords = new HashSet<DSRExternalRecord>();
    private static final ThreadLocal<JdsrStatistics> threatLocalStatistics;

    public static JdsrStatistics getInstance() {
        return threatLocalStatistics.get();
    }

    public void startCollectingData() {
        this.shouldCollectData = true;
    }

    public boolean shouldCollectData() {
        return this.shouldCollectData;
    }

    public void stopCollectingData() {
        this.shouldCollectData = false;
        threatLocalStatistics.remove();
    }

    public Set<DSRExternalRecord> getDsrExternalRecords() {
        return this.externalRecords;
    }

    public void addExternalRecord(long durationInMillis, HttpConnectionInfo httpConnectionInfo, HttpDestinationInfo httpDestinationInfo) {
        if (!this.shouldCollectData) {
            return;
        }
        String destinationUrl = httpDestinationInfo.getDestinationUrl();
        String type = "HTTP";
        String addInfo = this.getAdditionalInfo(httpDestinationInfo);
        int sentBytes = -1;
        int receivedBytes = -1;
        byte[] connectionId = httpConnectionInfo.getId();
        int connectionCounter = httpConnectionInfo.getCounter();
        DSRExternalRecord dsrExternalRecord = new DSRExternalRecord(durationInMillis, (long)receivedBytes, (long)sentBytes, destinationUrl, addInfo, thisSystemId, connectionCounter, connectionId, type);
        this.externalRecords.add(dsrExternalRecord);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("New DSR external record created: Duration %d; Received bytes: %d; Sent bytes: %d; Destination: %s; Additional info: %s; System ID: %s; Connections counter: %d; Connection ID: %s; Type: %s ", durationInMillis, receivedBytes, sentBytes, destinationUrl, addInfo, thisSystemId, connectionCounter, new String(connectionId, Charset.forName("UTF-8")), type));
        }
    }

    private String getAdditionalInfo(HttpDestinationInfo httpDestinationInfo) {
        String delimiter = ";";
        String keyValueDelimiter = ": ";
        StringBuffer sb = new StringBuffer();
        sb.append("HttpDestination details: ");
        sb.append("Name");
        sb.append(keyValueDelimiter);
        sb.append(httpDestinationInfo.getName());
        sb.append(delimiter);
        sb.append("Authentication");
        sb.append(keyValueDelimiter);
        sb.append(httpDestinationInfo.getProperty("Authentication"));
        sb.append(delimiter);
        sb.append("ProxyType");
        sb.append(keyValueDelimiter);
        sb.append(HttpDestinationInfoUtils.getProxyTypeValue(httpDestinationInfo));
        return sb.toString();
    }

    static {
        StringBuffer sb = new StringBuffer();
        sb.append(System.getenv(HC_ACCOUNT));
        sb.append(":");
        sb.append(System.getenv(HC_APPLICATION));
        sb.append(":");
        sb.append(System.getenv(HC_PROCESS_ID));
        thisSystemId = sb.toString();
        threatLocalStatistics = new ThreadLocal<JdsrStatistics>(){

            @Override
            protected JdsrStatistics initialValue() {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Creating a new thread local instance of " + JdsrStatistics.class + " in thread " + Thread.currentThread().getName());
                }
                return new JdsrStatistics();
            }
        };
    }
}

