/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.jndi;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.destinations.jndi.ReferenceServiceObjectFactory;
import com.sap.core.connectivity.httpdestination.internal.api.ISystemDestinationsService;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;

public class JavaServiceObjectFactory
extends ReferenceServiceObjectFactory {
    private static final Logger log = Logger.getLogger(JavaServiceObjectFactory.class.getName());
    private static ISystemDestinationsService systemDestinationsService;

    public JavaServiceObjectFactory() {
        super(JavaServiceObjectFactory.getSupportedReferences());
    }

    private static Map<String, ReferenceServiceObjectFactory.ReferenceHandler> getSupportedReferences() {
        return Collections.singletonMap(ISystemDestinationsService.class.getName(), new ReferenceServiceObjectFactory.ReferenceHandler(){

            @Override
            public Object getObjectInstance(Reference ref, Name name, Context nameCtx, Hashtable<?, ?> environment) throws DestinationException {
                ISystemDestinationsService systemDestinationsService = JavaServiceObjectFactory.getSystemDestinationsService();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Will return ISystemDestinationsService instance : " + systemDestinationsService);
                }
                return systemDestinationsService;
            }
        });
    }

    private static ISystemDestinationsService getSystemDestinationsService() {
        if (systemDestinationsService == null && !RUNTIME_UTIL.isOsgiRuntime()) {
            systemDestinationsService = RUNTIME_UTIL.loadJavaService(ISystemDestinationsService.class);
        }
        if (systemDestinationsService == null) {
            throw new IllegalStateException("Missing ISystemDestinationsService service");
        }
        return systemDestinationsService;
    }
}

