/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.s2s;

import com.sap.core.connectivity.httpdestination.impl.s2s.S2SEndpoint;
import com.sap.core.connectivity.httpdestination.impl.utils.URIUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

class DirectS2SEndpoint
implements S2SEndpoint {
    private static final Logger log = Logger.getLogger(DirectS2SEndpoint.class.getName());
    private final URI uri;

    DirectS2SEndpoint(String host, int port, String destinationUrl) {
        String path = this.extractPath(destinationUrl);
        this.uri = this.calculateURI(host, port, path);
    }

    DirectS2SEndpoint(DirectS2SEndpoint other) {
        this.uri = other.getURI();
    }

    private URI calculateURI(String host, int port, String path) {
        try {
            URI directURI = URIUtils.createURI("https", null, host, port, path, null, null);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Using direct S2S endpoint URI: " + directURI);
            }
            return directURI;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to generate direct S2S URI", e);
        }
    }

    private String extractPath(String url) {
        try {
            return new URI(url).getRawPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse destination URL", e);
        }
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }
}

