/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.s2s;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class DnsCache {
    private static final Logger log = Logger.getLogger(DnsCache.class.getName());
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("^(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})$");
    private static final ConcurrentHashMap<String, String> dnsCache = new ConcurrentHashMap();

    DnsCache() {
    }

    String getHostname(String ipAddress) {
        String hostname = dnsCache.get(ipAddress);
        if (hostname == null) {
            this.updateDNSCache(ipAddress, false);
            hostname = dnsCache.get(ipAddress);
        }
        return hostname;
    }

    private void updateDNSCache(String host, boolean force) {
        InetAddress inetAddress = this.dnsLookup(host);
        if (inetAddress == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("%s dns lookup failed, trying again", host));
            }
            inetAddress = this.dnsLookup(host);
        }
        if (inetAddress != null) {
            String ipAddress = inetAddress.getHostAddress();
            String hostname = inetAddress.getHostName();
            if (force) {
                dnsCache.put(ipAddress, hostname);
            } else {
                dnsCache.putIfAbsent(ipAddress, hostname);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("%s was cached to %s", ipAddress, hostname));
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("%s dns lookup failed", host));
            }
            if (force) {
                throw new IllegalStateException(String.format("Dns cache cannot be updated - %s dns lookup failed", host));
            }
        }
    }

    private InetAddress dnsLookup(String host) {
        block3: {
            try {
                InetAddress inetAddress = InetAddress.getByName(host);
                String domainName = inetAddress.getHostName();
                if (this.isDomainName(domainName)) {
                    return inetAddress;
                }
            }
            catch (UnknownHostException ex) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, String.format("Error during %s dns lookup", host), ex);
            }
        }
        return null;
    }

    private boolean isDomainName(String domainName) {
        return !IP_ADDRESS_PATTERN.matcher(domainName).matches();
    }

    void refresh(String url) throws MalformedURLException {
        this.updateDNSCache(new URL(url).getHost(), true);
    }

    void clear() {
        dnsCache.clear();
    }
}

