/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.s2s;

import com.sap.core.connectivity.httpdestination.common.HttpDestinationHeader;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.impl.AbstractHttpClientWrapper;
import com.sap.core.connectivity.httpdestination.impl.HttpClientOperation;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationClientContext;
import com.sap.core.connectivity.httpdestination.impl.header.InternalSystemAuthenticationCertificateHeader;
import com.sap.core.connectivity.httpdestination.impl.s2s.S2SEndpoint;
import com.sap.core.connectivity.httpdestination.impl.s2s.S2SEndpointService;
import com.sap.core.connectivity.httpdestination.impl.utils.URIUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;

public final class HttpS2SClientWrapper
extends AbstractHttpClientWrapper {
    private static final Logger log = Logger.getLogger(HttpS2SClientWrapper.class.getName());
    private static final S2SEndpointService endpointService = new S2SEndpointService();
    private final HttpClient discoveryClient;
    private final ReadWriteLock configurationLock = new ReentrantReadWriteLock();
    private S2SEndpoint endpoint;

    public HttpS2SClientWrapper(CloseableHttpClient httpClient, HttpDestinationClientContext httpClientContext, CloseableHttpClient discoveryClient) {
        super(httpClient, httpClientContext, HttpS2SClientWrapper.getHttpDestinationHeaders(httpClientContext.getHttpDestinationInfo()));
        this.discoveryClient = discoveryClient;
        this.endpoint = endpointService.create((HttpClient)discoveryClient, this.httpDestinationInfo.getDestinationUrl());
    }

    private static List<HttpDestinationHeader> getHttpDestinationHeaders(HttpDestinationInfo httpDestinationInfo) {
        ArrayList<HttpDestinationHeader> resHttpDestinationHeaders = null;
        List<HttpDestinationHeader> httpDestinationHeaders = httpDestinationInfo.getHeaders();
        if (httpDestinationHeaders == null) {
            resHttpDestinationHeaders = new ArrayList<HttpDestinationHeader>(1);
        } else {
            resHttpDestinationHeaders = new ArrayList(httpDestinationHeaders.size() + 1);
            resHttpDestinationHeaders.addAll(httpDestinationHeaders);
        }
        resHttpDestinationHeaders.add(new InternalSystemAuthenticationCertificateHeader(httpDestinationInfo, httpDestinationInfo.getProperties().getProperty("EnableS2SClientHeader", "false").equalsIgnoreCase("true")));
        return resHttpDestinationHeaders;
    }

    @Override
    protected <T> T execute(HttpClientOperation<T> operation, HttpContext context) throws IOException {
        try {
            return this.executeWithLocking(operation, context);
        }
        catch (ConnectException ex) {
            return this.refreshEndpointAndExecuteWithLocking(ex, operation, context, true);
        }
        catch (NoRouteToHostException ex) {
            return this.refreshEndpointAndExecuteWithLocking(ex, operation, context, false);
        }
        catch (UnknownHostException ex) {
            return this.refreshEndpointAndExecuteWithLocking(ex, operation, context, true);
        }
        catch (ConnectTimeoutException ex) {
            if (ex instanceof ConnectionPoolTimeoutException) {
                throw ex;
            }
            return this.refreshEndpointAndExecuteWithLocking((Exception)((Object)ex), operation, context, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithLocking(HttpClientOperation<T> operation, HttpContext context) throws IOException {
        this.configurationLock.readLock().lock();
        try {
            T t = this.executeOperation(operation, context);
            return t;
        }
        finally {
            this.configurationLock.readLock().unlock();
        }
    }

    private <T> T refreshEndpointAndExecuteWithLocking(Exception ex, HttpClientOperation<T> operation, HttpContext context, boolean refreshDnsCache) throws IOException {
        log.log(Level.WARNING, "Seems S2S endpoint not valid anymore. Will try to update S2S endpoint configuration and retry request.", ex);
        this.refreshEndpoint(refreshDnsCache);
        return this.executeWithLocking(operation, context);
    }

    private void refreshEndpoint(boolean refreshDns) {
        this.configurationLock.writeLock().lock();
        try {
            this.endpoint = endpointService.recreateOnFailure(this.discoveryClient, this.httpDestinationInfo.getDestinationUrl(), refreshDns);
        }
        finally {
            this.configurationLock.writeLock().unlock();
        }
    }

    @Override
    protected URI convertRequestURIAccordingToDestinationUri(URI requestURI) {
        try {
            URI destURI = this.endpoint.getURI();
            if (requestURI != null) {
                String requestPath = requestURI.getRawPath();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Will convert request path: " + requestPath);
                }
                String destUrlPath = destURI.getRawPath();
                requestPath = URIUtils.concatenateURLPaths(destUrlPath, requestPath);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Converted request path: " + requestPath);
                }
                return URIUtils.createURI(destURI.getScheme(), requestURI.getRawUserInfo(), destURI.getHost(), destURI.getPort(), requestPath, requestURI.getRawQuery(), requestURI.getRawFragment());
            }
            String requestPath = destURI.getRawPath();
            requestPath = requestPath.replaceAll("^/", "");
            requestPath = "/" + requestPath;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Request : " + requestPath);
            }
            return URIUtils.createURI(destURI.getScheme(), destURI.getRawUserInfo(), destURI.getHost(), destURI.getPort(), requestPath, destURI.getRawQuery(), destURI.getRawFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Request URI cannot be converted according to destination URI", ex);
        }
    }

    @Override
    protected final HttpHost convertHttpHost(HttpHost target) {
        HttpHost s2starget = this.getHttpHostFromDestinationUrl();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Will use S2S target host: " + s2starget);
        }
        return s2starget;
    }

    private HttpHost getHttpHostFromDestinationUrl() {
        URI uri = this.endpoint.getURI();
        return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    @Override
    protected boolean shouldCollectJdsr() {
        return false;
    }
}

