/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.s2s;

import com.sap.core.connectivity.httpdestination.impl.s2s.S2SEndpoint;
import java.net.URI;
import java.net.URISyntaxException;

class IndirectS2SEndpoint
implements S2SEndpoint {
    private final URI uri;

    IndirectS2SEndpoint(String destinationUrl) {
        try {
            this.uri = new URI(destinationUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse destination URL", e);
        }
    }

    IndirectS2SEndpoint(IndirectS2SEndpoint other) {
        this.uri = other.getURI();
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }
}

