/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.s2s;

import com.sap.core.connectivity.httpdestination.impl.s2s.DirectS2SEndpoint;
import com.sap.core.connectivity.httpdestination.impl.s2s.DnsCache;
import com.sap.core.connectivity.httpdestination.impl.s2s.IndirectS2SEndpoint;
import com.sap.core.connectivity.httpdestination.impl.s2s.S2SEndpoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class S2SEndpointService {
    private static final Logger log = Logger.getLogger(S2SEndpointService.class.getName());
    private static final String LB_DISCOVERY_REQUEST_HEADER = "sap.s2s.discovery";
    private static final String LB_DISCOVERY_REQUEST_HEADER_VALUE = "choose_one";
    private static final int LB_DISCOVERY_REQUEST_CONNECTION_TIMEOUT = 30000;
    private static final int LB_DISCOVERY_REQUEST_SO_TIMEOUT = 60000;
    private static final int CHECK_SOCKET_CONNECTION_TIMEOUT = 10000;
    private static final int CHECK_SOCKET_SO_TIMEOUT = 10000;
    private static final Pattern REGEX_DISCOVERY_RESPONSE_PATTERN = Pattern.compile("^pool.*member\\s+(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})\\s+(\\d{1,5})$");
    private final long discoveryInterval;
    private final long renewInterval;
    private final DirectAccessChecker directAccessChecker;
    private DnsCache dnsCache = new DnsCache();
    private final Map<String, S2SEnpointInfo> endpoints = new HashMap<String, S2SEnpointInfo>();

    S2SEndpointService() {
        this(600000L, 3600000L, new DefaultDirectAccessChecker());
    }

    S2SEndpointService(long discoveryInterval, long renewInterval, DirectAccessChecker directAccessChecker) {
        this.discoveryInterval = discoveryInterval;
        this.renewInterval = renewInterval;
        this.directAccessChecker = directAccessChecker;
    }

    public synchronized S2SEndpoint create(HttpClient discoveryClient, String url) {
        S2SEnpointInfo endpointInfo = this.endpoints.get(url);
        if (endpointInfo == null || this.needsRenewal(endpointInfo)) {
            endpointInfo = this.createEndpointInfo(discoveryClient, url);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("Acquired S2S endpoint for url %s: %s", url, endpointInfo));
        }
        return endpointInfo.getEndpointClone();
    }

    private String replaceIpAddressWithHostname(String ipAddress) {
        String hostname = this.dnsCache.getHostname(ipAddress);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("IP address: %s Will use hostname from cache: %s", ipAddress, hostname));
        }
        return hostname;
    }

    private boolean needsRenewal(S2SEnpointInfo endpointInfo) {
        return System.currentTimeMillis() > endpointInfo.getDiscoveryTimestamp() + this.renewInterval;
    }

    public synchronized S2SEndpoint recreateOnFailure(HttpClient discoveryClient, String url, boolean refreshDnsCache) {
        S2SEnpointInfo endpointInfo = this.endpoints.get(url);
        if (endpointInfo == null) {
            throw new IllegalStateException("Unable to find S2S endpoint for url " + url);
        }
        if (System.currentTimeMillis() > endpointInfo.getDiscoveryTimestamp() + this.discoveryInterval || refreshDnsCache) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Timeout passed. Will update S2S endpoint configuration.");
            }
            try {
                this.dnsCache.refresh(url);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Malformed destination URL", ex);
            }
            this.endpoints.remove(url);
            endpointInfo = this.createEndpointInfo(discoveryClient, url);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Timeout not passed. Will rollback S2S endpoint configuration.");
            }
            endpointInfo = this.createEndpointInfo(new IndirectS2SEndpoint(url), url);
        }
        return endpointInfo.getEndpointClone();
    }

    private S2SEnpointInfo createEndpointInfo(HttpClient discoveryClient, String url) {
        return this.createEndpointInfo(this.createEndpoint(discoveryClient, url), url);
    }

    private S2SEnpointInfo createEndpointInfo(S2SEndpoint endpoint, String url) {
        S2SEnpointInfo endpointInfo = new S2SEnpointInfo(endpoint, System.currentTimeMillis());
        this.endpoints.put(url, endpointInfo);
        return endpointInfo;
    }

    private S2SEndpoint createEndpoint(HttpClient discoveryClient, String url) {
        DirectS2SEndpoint directEndpoint = this.tryCreateDirectEndpoint(discoveryClient, url);
        if (directEndpoint != null) {
            return directEndpoint;
        }
        return new IndirectS2SEndpoint(url);
    }

    private DirectS2SEndpoint tryCreateDirectEndpoint(HttpClient discoveryClient, String url) {
        String response = this.executeDiscoveryRequest(discoveryClient, url);
        if (response == null) {
            return null;
        }
        Matcher matcher = REGEX_DISCOVERY_RESPONSE_PATTERN.matcher(response);
        if (!matcher.matches()) {
            log.log(Level.WARNING, "Direct S2S discovery: Unexpected response content: " + response);
            return null;
        }
        String ipAddress = matcher.group(1);
        String hostname = this.replaceIpAddressWithHostname(ipAddress);
        if (hostname == null) {
            log.log(Level.WARNING, String.format("Could not resolve hostname for IP address: %s", ipAddress));
            return null;
        }
        int port = Integer.parseInt(matcher.group(2));
        if (!this.directAccessChecker.isHostAccessibleDirectly(hostname, port)) {
            log.log(Level.WARNING, String.format("Hostname [%s] is not directly accessible", hostname));
            return null;
        }
        log.info("Direct S2S to [" + hostname + ":" + hostname + "]");
        return new DirectS2SEndpoint(hostname, port, url);
    }

    private String executeDiscoveryRequest(HttpClient discoveryClient, String url) {
        try {
            HttpGet request = new HttpGet(url);
            request.setHeader(LB_DISCOVERY_REQUEST_HEADER, LB_DISCOVERY_REQUEST_HEADER_VALUE);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(60000).build();
            request.setConfig(requestConfig);
            HttpResponse response = discoveryClient.execute((HttpUriRequest)request);
            int responseCode = response.getStatusLine().getStatusCode();
            String missingResponseBody = String.format("Discover service IP for direct S2S communication - URL [%s] finished with response code [%d]; Mandatory request body is not set or empty!", url, responseCode);
            if (response.getEntity() == null) {
                log.log(Level.SEVERE, missingResponseBody);
                return null;
            }
            String responseAsString = EntityUtils.toString((HttpEntity)response.getEntity());
            if (responseAsString == null || responseAsString.isEmpty()) {
                log.log(Level.SEVERE, missingResponseBody);
                return null;
            }
            if (responseCode < 200 || responseCode >= 300) {
                log.log(Level.WARNING, "Discover service IP for direct S2S communication - URL [" + url + "] failed with response code " + responseCode + "; request body [" + responseAsString + "]");
                return null;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Discover service IP for direct S2S communication - URL [" + url + "] succeeded with response code " + responseCode + "; request body [" + responseAsString + "]");
            }
            return responseAsString;
        }
        catch (IOException ioEx) {
            log.log(Level.WARNING, "Discover service IP for direct S2S communication - URL [" + url + "] failed", ioEx);
            return null;
        }
    }

    public void clearEndpoints() {
        this.endpoints.clear();
    }

    private static final class DefaultDirectAccessChecker
    implements DirectAccessChecker {
        private DefaultDirectAccessChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isHostAccessibleDirectly(String host, int port) {
            Socket checkSocket = new Socket();
            try {
                checkSocket.setSoTimeout(10000);
                checkSocket.connect(new InetSocketAddress(host, port), 10000);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("Successfully opened socket to [%s:%d]", host, port));
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("Cannot establish direct connection to [%s:%d]", host, port), e);
                }
            }
            finally {
                block14: {
                    try {
                        checkSocket.close();
                    }
                    catch (IOException e) {
                        if (!log.isLoggable(Level.FINE)) break block14;
                        log.log(Level.FINE, "Socket cannot be closed due to the following connection problem: ", e);
                    }
                }
            }
            return false;
        }
    }

    static interface DirectAccessChecker {
        public boolean isHostAccessibleDirectly(String var1, int var2);
    }

    private static final class S2SEnpointInfo {
        private final S2SEndpoint endpoint;
        private final long discoveryTimestamp;

        private S2SEnpointInfo(S2SEndpoint endpoint, long discoveryTimestamp) {
            this.endpoint = endpoint;
            this.discoveryTimestamp = discoveryTimestamp;
        }

        public S2SEndpoint getEndpointClone() {
            if (this.endpoint instanceof DirectS2SEndpoint) {
                return new DirectS2SEndpoint((DirectS2SEndpoint)this.endpoint);
            }
            return new IndirectS2SEndpoint((IndirectS2SEndpoint)this.endpoint);
        }

        public long getDiscoveryTimestamp() {
            return this.discoveryTimestamp;
        }

        public String toString() {
            return this.endpoint.toString();
        }
    }
}

