/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.trustmanager;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;

public class TrustMultipleTruststoreManager
implements X509TrustManager {
    private final X509TrustManager[] trustManagers;

    public TrustMultipleTruststoreManager(X509TrustManager ... trustManagers) {
        if (trustManagers == null) {
            throw new IllegalArgumentException("Trust mangers can not be null");
        }
        this.trustManagers = trustManagers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean isclientTrusted = false;
        CertificateException thrownError = null;
        for (X509TrustManager trustManager : this.trustManagers) {
            if (trustManager == null) continue;
            try {
                trustManager.checkClientTrusted(chain, authType);
                isclientTrusted = true;
                break;
            }
            catch (CertificateException ex) {
                thrownError = ex;
            }
        }
        if (!isclientTrusted && thrownError != null) {
            throw thrownError;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean isclientTrusted = false;
        CertificateException thrownError = null;
        for (X509TrustManager trustManager : this.trustManagers) {
            if (trustManager == null) continue;
            try {
                trustManager.checkServerTrusted(chain, authType);
                isclientTrusted = true;
                break;
            }
            catch (CertificateException ex) {
                thrownError = ex;
            }
        }
        if (!isclientTrusted && thrownError != null) {
            throw thrownError;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> issuersList = new ArrayList<X509Certificate>();
        X509Certificate[] accepCertificates = null;
        for (X509TrustManager trustManager : this.trustManagers) {
            if (trustManager == null || (accepCertificates = trustManager.getAcceptedIssuers()) == null) continue;
            issuersList.addAll(Arrays.asList(accepCertificates));
        }
        if (!issuersList.isEmpty()) {
            return issuersList.toArray(new X509Certificate[0]);
        }
        return null;
    }
}

