/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.impl.utils;

import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.ProxyType;
import com.sap.core.connectivity.httpdestination.impl.utils.URIUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class HttpDestinationInfoUtils {
    private static final Map<ProxyType, String> enumToStringProxyType = new HashMap<ProxyType, String>();

    public static boolean isOnPremiseDestination(HttpDestinationInfo info) {
        return ProxyType.ON_PREMISE == info.getProxyType();
    }

    public static String getProxyTypeValue(HttpDestinationInfo info) {
        return enumToStringProxyType.get((Object)info.getProxyType());
    }

    public static URI convertUrl(URI requestURI, HttpDestinationInfo httpDestinationInfo) throws URISyntaxException {
        URI destURI = new URI(httpDestinationInfo.getDestinationUrl());
        if (requestURI != null) {
            HttpDestinationInfoUtils.check(requestURI, destURI, httpDestinationInfo);
            String requestPath = URIUtils.concatenateURLPaths(destURI.getRawPath(), requestURI.getRawPath());
            return URIUtils.createURI(destURI.getScheme(), requestURI.getRawUserInfo(), destURI.getHost(), destURI.getPort(), requestPath, requestURI.getRawQuery(), requestURI.getRawFragment());
        }
        String requestPath = destURI.getRawPath();
        requestPath = requestPath.replaceAll("^/", "");
        requestPath = "/" + requestPath;
        return URIUtils.createURI(destURI.getScheme(), destURI.getRawUserInfo(), destURI.getHost(), destURI.getPort(), requestPath, destURI.getRawQuery(), destURI.getRawFragment());
    }

    private static void check(URI requestURI, URI destinationURI, HttpDestinationInfo httpDestinationInfo) throws URISyntaxException {
        if (requestURI.getHost() != null) {
            boolean isSchemeEqual = HttpDestinationInfoUtils.isOnPremiseDestination(httpDestinationInfo) || destinationURI.getScheme().equalsIgnoreCase(requestURI.getScheme());
            boolean isHostEqual = destinationURI.getHost().equalsIgnoreCase(requestURI.getHost());
            boolean isPortEqual = requestURI.getPort() == -1 || destinationURI.getPort() == requestURI.getPort();
            String destinationUriPath = destinationURI.getPath().endsWith("/") ? destinationURI.getPath().substring(0, destinationURI.getPath().length() - 1) : destinationURI.getPath();
            boolean requestPathStartsWithDestinationPath = requestURI.getPath().startsWith(destinationUriPath);
            if (!(isSchemeEqual && isHostEqual && isPortEqual && requestPathStartsWithDestinationPath)) {
                throw new URISyntaxException(requestURI.toString(), "URIs defined in destination '" + destinationURI + "' and supplied by application code '" + requestURI + "' differ");
            }
        }
    }

    static {
        enumToStringProxyType.put(ProxyType.INTERNAL, "Internal");
        enumToStringProxyType.put(ProxyType.INTERNET, "Internet");
        enumToStringProxyType.put(ProxyType.ON_PREMISE, "OnPremise");
    }
}

