/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.onpremise;

import com.sap.core.connectivity.cloud.destinations.tunnel.ConnectivityProxyAddressReader;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.ConnectivityDefaultDnsResolver;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.CustomRegistry;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.protocol.HttpContext;

class ConnectivityClientConnectionOperator
extends DefaultHttpClientConnectionOperator {
    private static Logger log = Logger.getLogger(ConnectivityClientConnectionOperator.class.getName());
    private ConnectivityProxyAddressReader connectivityProxyAddressReader;

    ConnectivityClientConnectionOperator(CustomRegistry<ConnectionSocketFactory> registry, ConnectivityProxyAddressReader connectivityProxyAddressReader) {
        super(registry, (SchemePortResolver)new DefaultSchemePortResolver(), (DnsResolver)new ConnectivityDefaultDnsResolver());
        this.connectivityProxyAddressReader = connectivityProxyAddressReader;
    }

    public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, int connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Connecting to " + this.connectivityProxyAddressReader.getConnectivityProxyAddress());
                log.log(Level.FINE, "Connecting to host " + host.getHostName() + " port " + host.getPort() + " address " + host.getAddress());
            }
            super.connect(conn, host, localAddress, connectTimeout, socketConfig, context);
        }
        catch (HttpHostConnectException e) {
            HttpHost connectivityAgentTarget = new HttpHost("localhost", this.connectivityProxyAddressReader.getConnectivityProxyAddress().getPort());
            throw new HttpHostConnectException((IOException)new ConnectException("Unable to connect to connectivity proxy"), connectivityAgentTarget, new InetAddress[0]);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, String.format("Failed to connect to connectivity proxy at %s", this.connectivityProxyAddressReader.getConnectivityProxyAddress()));
            throw ex;
        }
    }
}

