/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.onpremise;

import com.sap.core.connectivity.cloud.destinations.tunnel.ConnectionProtocol;
import com.sap.core.connectivity.cloud.destinations.tunnel.ConnectivityProxyAddressReader;
import com.sap.core.connectivity.cloud.destinations.tunnel.ConnectivitySocket;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.AuthenticationCredentials;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.ConnectivityClientConnectionOperator;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.ConnectivityContextInformationProvider;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.CustomRegistry;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpHost;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

class ConnectivityClientConnectionOperatorFactory {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    ConnectivityClientConnectionOperatorFactory() {
    }

    static HttpClientConnectionOperator createConnectivityClientConnectionOperator(final ConnectivityContextInformationProvider contextInformationProvider, final ConnectivityProxyAddressReader connectivityProxyAddressReader) {
        PlainConnectionSocketFactory factory = new PlainConnectionSocketFactory(){

            public Socket createSocket(HttpContext context) {
                String tunnelId = contextInformationProvider.getTunnelId();
                Properties connectionInfo = contextInformationProvider.getConnectionInfo();
                AuthenticationCredentials singleSignOnCredentials = contextInformationProvider.getSingleSignOnCredentials();
                return this.createConnectivitySocket(tunnelId, connectionInfo, singleSignOnCredentials);
            }

            private ConnectivitySocket createConnectivitySocket(String tunnelId, Properties connectionInfo, AuthenticationCredentials singleSignOnCredentials) {
                try {
                    if (singleSignOnCredentials != null) {
                        return new ConnectivitySocket(tunnelId, ConnectionProtocol.HTTP, singleSignOnCredentials.getToken(), singleSignOnCredentials.getType(), connectivityProxyAddressReader, connectionInfo);
                    }
                    return new ConnectivitySocket(tunnelId, ConnectionProtocol.HTTP, connectivityProxyAddressReader, connectionInfo);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException("Connectivity socket cannot be created", ex);
                }
            }

            public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                InetSocketAddress virtualAddress = InetSocketAddress.createUnresolved(host.getHostName(), host.getPort());
                return super.connectSocket(connectTimeout, socket, host, virtualAddress, localAddress, context);
            }
        };
        ConcurrentHashMap<String, 1> socketFactoryMap = new ConcurrentHashMap<String, 1>();
        socketFactoryMap.put(HTTP, factory);
        socketFactoryMap.put(HTTPS, factory);
        return new ConnectivityClientConnectionOperator(new CustomRegistry<ConnectionSocketFactory>(socketFactoryMap), connectivityProxyAddressReader);
    }
}

