/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.onpremise;

import com.sap.core.connectivity.httpdestination.common.HttpDestinationContext;
import com.sap.core.connectivity.httpdestination.impl.DefaultHttpRequestExecutionCustomizer;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.ConnectivityContextInformationProvider;

public class ConnectivityHttpRequestExecutionCustomizer
extends DefaultHttpRequestExecutionCustomizer {
    protected final ConnectivityContextInformationProvider contextInformationProvider;
    private final String tunnelId;

    public ConnectivityHttpRequestExecutionCustomizer(ConnectivityContextInformationProvider contextInformationProvider) {
        this.contextInformationProvider = contextInformationProvider;
        this.tunnelId = contextInformationProvider.getTunnelId();
    }

    @Override
    public void customizeRequest(HttpDestinationContext context) {
        this.checkTunnelId();
        super.customizeRequest(context);
    }

    private void checkTunnelId() {
        if (!this.tunnelId.equals(this.contextInformationProvider.getTunnelId())) {
            throw new IllegalArgumentException("Same instance of HttpClient for OnPremise destinations cannot be used by different tenants. If you want to cache the HttpClient instance, use the user session.");
        }
    }
}

